﻿Imports centrafuse.Plugins
Imports System
Imports System.Runtime.InteropServices
Imports System.Text
Imports System.Threading
Imports Microsoft.VisualBasic.Interaction
Imports System.xml

Namespace Radio
    Public Class USBRadio

        Implements ICFRadio


        Private LPT As Integer
        Private LptCE As Short
        Private LptData As Short
        Private LptCL As Short
        Private Adjust As Integer
        Private StepNet As Integer
        Private Delay As Integer
        Private SoundCard As Integer
        Private Mixer As Integer
        Private MixerVolume As Integer
        Private R0 As Short
        Private R1 As Short
        Private R2 As Short
        Private CurFreq As Single
        Private _procDE As System.Diagnostics.Process
        Private configxml As XmlDocument

        Public Function GetRDSInformation() As String Implements centrafuse.Plugins.ICFRadio.GetRDSInformation
            Try
                Return ""
            Catch exception As Exception
                CFTools.writeError(exception.Message, exception.StackTrace)
            End Try
            Return Nothing
        End Function

        Public Function GetStation() As Integer Implements centrafuse.Plugins.ICFRadio.GetStation
            Return -1
        End Function

        Public Function InitializeRadio() As Boolean Implements centrafuse.Plugins.ICFRadio.InitializeRadio
            Dim flag As Boolean = False
            AddHandler Microsoft.Win32.SystemEvents.PowerModeChanged, AddressOf PowerModeChanged
            Try
                Dim Modul As System.Reflection.Module = System.Reflection.Assembly.GetExecutingAssembly().GetModules()(0)
                Dim Path As String = Modul.FullyQualifiedName
                Path = Path.Substring(0, Path.LastIndexOf("\")) & "\" & "config.xml"
                Me.configxml = New System.Xml.XmlDocument

                Me.configxml.Load(Path)
                LPT = CInt(Me.configxml.SelectSingleNode("/APPCONFIG/TUNER/LPT").InnerText)
                LptCE = CInt(Me.configxml.SelectSingleNode("/APPCONFIG/TUNER/LPTCE").InnerText)
                LptData = CInt(Me.configxml.SelectSingleNode("/APPCONFIG/TUNER/LPTDATA").InnerText)
                LptCL = CInt(Me.configxml.SelectSingleNode("/APPCONFIG/TUNER/LPTCL").InnerText)
                Adjust = CInt(Me.configxml.SelectSingleNode("/APPCONFIG/TUNER/ADJUST").InnerText)
                StepNet = CInt(Me.configxml.SelectSingleNode("/APPCONFIG/TUNER/STEPNET").InnerText)
                Delay = CInt(Me.configxml.SelectSingleNode("/APPCONFIG/TUNER/DELAYBIT").InnerText)

                SoundCard = CInt(Me.configxml.SelectSingleNode("/APPCONFIG/SOUND/CARD").InnerText)
                Mixer = CInt(Me.configxml.SelectSingleNode("/APPCONFIG/SOUND/MIXER").InnerText)
                MixerVolume = CInt(Me.configxml.SelectSingleNode("/APPCONFIG/SOUND/VOLUME").InnerText)
                Select Case (StepNet)
                    Case (1)
                        R0 = 1
                        R1 = 1
                        R2 = 0
                    Case (5)
                        R0 = 1
                        R1 = 1
                        R2 = 1
                    Case (9)
                        R0 = 1
                        R1 = 0
                        R2 = 1
                    Case (10)
                        R0 = 1
                        R1 = 0
                        R2 = 0
                    Case (25)
                        R0 = 0
                        R1 = 1
                        R2 = 0
                    Case (50)
                        R0 = 0
                        R1 = 0
                        R2 = 1
                    Case Else
                        R0 = 0
                        R1 = 0
                        R2 = 0
                End Select

                Call mMixer.OpenMixer(SoundCard)
                OnOffUsb(True)
                flag = True
            Catch exception As Exception
                CFTools.writeError(exception.Message, exception.StackTrace)
            End Try
            Return flag
        End Function

        Public Sub Mute() Implements centrafuse.Plugins.ICFRadio.Mute
            Try
                RadioOff()
                'mMixer.Volume(Mixer) = 0
            Catch exception As Exception
                CFTools.writeError(exception.Message, exception.StackTrace)
            End Try
        End Sub

        Public ReadOnly Property RadioDevice() As String Implements centrafuse.Plugins.ICFRadio.RadioDevice
            Get
                Return "FMAvto"
            End Get
        End Property

        Public Function ResumeRadio(ByVal currentFreq As Integer) As Boolean Implements centrafuse.Plugins.ICFRadio.ResumeRadio
            Try
                Dim Divisor As Integer
                Dim RF As Integer
                Dim Str As String
                Dim asd(0 To 23) As Short
                Dim i As Short
                CurFreq = currentFreq
                RF = currentFreq * 10

                Divisor = (Adjust + RF) / StepNet
                Str = Bin(Divisor, 14)
                For i = 0 To 13 'D0-D13
                    asd(i) = CInt(Microsoft.VisualBasic.Mid(Str, 14 - i, 1))
                Next i
                asd(14) = 0 ' T0
                asd(15) = 0 ' T1

                asd(16) = 0 ' B0
                asd(17) = 0 ' B1
                asd(18) = 1 ' B2
                asd(19) = 0 ' TB

                asd(20) = R0 ' R0
                asd(21) = R1 ' R1
                asd(22) = R2 ' R2

                asd(23) = 1 ' S

                WriteLPT(asd, LPT, Delay, LptCE, LptData, LptCL)
                'mMixer.Volume(Mixer) = MixerVolume
            Catch exception As Exception
                CFTools.writeError(exception.Message, exception.StackTrace)
            End Try
            Return True
        End Function

        Public Function SeekFreq(ByVal searchDirection As centrafuse.Plugins.RADIO_DIRECTION, ByVal currentFreq As Integer) As Integer Implements centrafuse.Plugins.ICFRadio.SeekFreq
            Try
                Select Case searchDirection
                    Case RADIO_DIRECTION.UP
                        Return (currentFreq)

                    Case RADIO_DIRECTION.DOWN

                        Return (currentFreq)
                End Select
            Catch exception As Exception
                CFTools.writeError(exception.Message, exception.StackTrace)
            End Try
            Return -1
        End Function

        Public Function SetTuneBand(ByVal Band As centrafuse.Plugins.RADIO_TUNE_BAND) As Boolean Implements centrafuse.Plugins.ICFRadio.SetTuneBand
            Return False
        End Function

        Public Sub ShutdownRadio() Implements centrafuse.Plugins.ICFRadio.ShutdownRadio
            Try

                RadioOff()
                Call mMixer.CloseMixer()
                OnOffUsb(False)
                RemoveHandler Microsoft.Win32.SystemEvents.PowerModeChanged, AddressOf PowerModeChanged

            Catch exception As Exception
                CFTools.writeError(exception.Message, exception.StackTrace)
            End Try

             
        End Sub
        Public Sub RadioOff()
            Try


                Dim Divisor As Integer
                Dim RF As Integer
                Dim Str As String
                Dim asd(0 To 23) As Short
                Dim i As Short

                RF = 87000

                Divisor = (Adjust + RF) / StepNet
                Str = Bin(Divisor, 14)
                For i = 0 To 13 'D0-D13
                    asd(i) = CInt(Microsoft.VisualBasic.Mid(Str, 14 - i, 1))
                Next i
                asd(14) = 0 ' T0
                asd(15) = 0 ' T1

                asd(16) = 0 ' B0
                asd(17) = 1 ' B1
                asd(18) = 0 ' B2
                asd(19) = 0 ' TB

                asd(20) = R0 ' R0
                asd(21) = R1 ' R1
                asd(22) = R2 ' R2

                asd(23) = 1 ' S

                WriteLPT(asd, LPT, Delay, LptCE, LptData, LptCL)
            Catch Exception As Exception
                CFTools.writeError(Exception.Message, Exception.StackTrace)
            End Try
        End Sub

        Public Sub StandbyRadio(ByVal currentFreq As Integer) Implements centrafuse.Plugins.ICFRadio.StandbyRadio
            Try
                RadioOff()
                mMixer.Volume(Mixer) = 0
            Catch exception As Exception
                CFTools.writeError(exception.Message, exception.StackTrace)
            End Try
        End Sub

        Public Function StereoLock() As Boolean Implements centrafuse.Plugins.ICFRadio.StereoLock
            Try
                Return True
            Catch exception As Exception
                CFTools.writeError(exception.Message, exception.StackTrace)
            End Try
            Return False
        End Function

        Public Function StereoLockSupport() As Boolean Implements centrafuse.Plugins.ICFRadio.StereoLockSupport
            Return True
        End Function

        Public Function TuneFreq(ByVal Freq As Integer) As Integer Implements centrafuse.Plugins.ICFRadio.TuneFreq
            Try

                Dim Divisor As Integer
                Dim RF As Integer

                Dim Str As String
                Dim asd(0 To 23) As Short
                Dim i As Short
                CurFreq = Freq
                RF = Freq * 10

                Divisor = (Adjust + RF) / StepNet
                Str = Bin(Divisor, 14)
                For i = 0 To 13 'D0-D13
                    asd(i) = CInt(Microsoft.VisualBasic.Mid(Str, 14 - i, 1))
                Next i
                asd(14) = 0 ' T0
                asd(15) = 0 ' T1

                asd(16) = 0 ' B0
                asd(17) = 0 ' B1
                asd(18) = 1 ' B2
                asd(19) = 0 ' TB

                asd(20) = R0 ' R0
                asd(21) = R1 ' R1
                asd(22) = R2 ' R2

                asd(23) = 1 ' S

                WriteLPT(asd, LPT, Delay, LptCE, LptData, LptCL)
                Return (Freq / 10)
            Catch exception As Exception
                CFTools.writeError(exception.Message, exception.StackTrace)
            End Try
            Return Freq
        End Function

        Public Sub UnMute() Implements centrafuse.Plugins.ICFRadio.UnMute
            Try
                TuneFreq(CurFreq)
                'mMixer.Volume(Mixer) = MixerVolume
            Catch exception As Exception
                CFTools.writeError(exception.Message, exception.StackTrace)
            End Try
        End Sub
        Private Sub OnOffUsb(ByVal OnOff As Boolean)
            Dim Modul As System.Reflection.Module = System.Reflection.Assembly.GetExecutingAssembly().GetModules()(0)
            Dim Path As String = Modul.FullyQualifiedName
            Path = Path.Substring(0, Path.LastIndexOf("\"))
            Me.procDE = New System.Diagnostics.Process
            Me.procDE.StartInfo.FileName = Path & "\" & "devcon.exe"
            Me.procDE.StartInfo.WorkingDirectory = Path
            If OnOff = True Then 'On
                Me.procDE.StartInfo.Arguments = "enable USB\Vid_16c0*"
            Else 'Off
                Me.procDE.StartInfo.Arguments = "disable USB\Vid_16c0*"
            End If
            Me.procDE.EnableRaisingEvents = True
            Me.procDE.StartInfo.CreateNoWindow = True
            Me.procDE.StartInfo.WindowStyle = System.Diagnostics.ProcessWindowStyle.Hidden
            Me.procDE.Start()
            Me.procDE.WaitForExit()
        End Sub

        Private Sub PowerModeChanged(ByVal Sender As System.Object, ByVal e As Microsoft.Win32.PowerModeChangedEventArgs)
            Select Case e.Mode
                Case Microsoft.Win32.PowerModes.Suspend
                    RadioOff()
                    OnOffUsb(False)
                Case Microsoft.Win32.PowerModes.Resume
                    OnOffUsb(True)
                    TuneFreq(CurFreq)
            End Select
        End Sub

        Private Sub procDE_Disposed(ByVal sender As Object, ByVal e As EventArgs)

            Me.procDE = Nothing

        End Sub

        Overridable Property procDE() As System.Diagnostics.Process
            Get
                Return Me._procDE
            End Get
            Set(ByVal WithEventsValue As System.Diagnostics.Process)
                If (Not Me._procDE Is Nothing) Then
                    RemoveHandler Me._procDE.Exited, New EventHandler(AddressOf Me.procDE_Disposed)
                    RemoveHandler Me._procDE.Disposed, New EventHandler(AddressOf Me.procDE_Disposed)
                End If
                Me._procDE = WithEventsValue
                If (Not Me._procDE Is Nothing) Then
                    AddHandler Me._procDE.Exited, New EventHandler(AddressOf Me.procDE_Disposed)
                    AddHandler Me._procDE.Disposed, New EventHandler(AddressOf Me.procDE_Disposed)
                End If
            End Set
        End Property
    End Class
End Namespace

