Option Strict Off
Option Explicit On
Friend Class Form1
	Inherits System.Windows.Forms.Form
    Private SetSetup As Boolean
    Friend DAODBEngine As New DAO.DBEngine
    Dim Region As String
    Dim City As String
    Private MainLoad As Boolean
    Private MdbPath As String
    Private LowRfFm1 As Integer
    Private HighRfFm1 As Integer
    Private LowRfFm2 As Integer
    Private HighRfFm2 As Integer
    Private StepNetFm1 As Integer
    Private StepNetFm2 As Integer
    Private Fm1Name As String
    Private Fm2Name As String
    Private Fm1Set As Boolean
    Private Fm2Set As Boolean
    Private LPTPort As Integer
    Private Adjust As Integer
    Private DelayBit As Integer
    Public DelayMute As Integer
    Private CurentRf As Integer
    Private _procDE As Process
    Private Off_Tuner As Boolean


	Private Sub Exit_Renamed_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Exit_Renamed.Click
		Me.Close()
	End Sub
	
	
	
	Private Sub Exit_Renamed_MouseMove(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.MouseEventArgs) Handles Exit_Renamed.MouseMove
		Dim Button As Short = eventArgs.Button \ &H100000
		Dim Shift As Short = System.Windows.Forms.Control.ModifierKeys \ &H10000
		Dim X As Single = VB6.PixelsToTwipsX(eventArgs.X)
		Dim Y As Single = VB6.PixelsToTwipsY(eventArgs.Y)
		Me.Exit_Renamed.ForeColor = System.Drawing.ColorTranslator.FromOle(&HFF0000)
    End Sub

    Private Sub Form1_Disposed(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Disposed
        mMixer.Volume(AudioMixer.SelectedIndex) = 0
        OffTuner()
        Call mMixer.CloseMixer()
        OnOffUsb(False)
        RemoveHandler Microsoft.Win32.SystemEvents.PowerModeChanged, AddressOf PowerModeChanged
    End Sub
    Private Sub PowerModeChanged(ByVal Sender As System.Object, ByVal e As Microsoft.Win32.PowerModeChangedEventArgs)
        Select Case e.Mode
            Case Microsoft.Win32.PowerModes.Suspend
                OffTuner()
                OnOffUsb(False)
            Case Microsoft.Win32.PowerModes.Resume
                OnOffUsb(True)
                SetTuner(CurentRf)
        End Select
    End Sub
    Private Sub OnOffUsb(ByVal OnOff As Boolean)
        Dim Modul As System.Reflection.Module = System.Reflection.Assembly.GetExecutingAssembly().GetModules()(0)
        Dim Path As String = Modul.FullyQualifiedName
        Path = Path.Substring(0, Path.LastIndexOf("\"))
        Me.procDE = New Process
        Me.procDE.StartInfo.FileName = Path & "\" & "devcon.exe"
        Me.procDE.StartInfo.WorkingDirectory = Path
        If OnOff = True Then 'On
            Me.procDE.StartInfo.Arguments = "enable USB\Vid_16c0*"
        Else 'Off
            Me.procDE.StartInfo.Arguments = "disable USB\Vid_16c0*"
        End If
        Me.procDE.EnableRaisingEvents = True
        Me.procDE.StartInfo.CreateNoWindow = True
        Me.procDE.StartInfo.WindowStyle = ProcessWindowStyle.Hidden
        Me.procDE.Start()
        Me.procDE.WaitForExit()
    End Sub
	Private Sub Form1_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
        Dim i As Short
        Dim RF As Integer
        Dim SelectedRow As Integer
		SetupGroup.Visible = False
		StationSw.Visible = True
        SetSetup = False
        MemStation.Enabled = False
        OnOffUsb(True)
        AddHandler Microsoft.Win32.SystemEvents.PowerModeChanged, AddressOf PowerModeChanged
        Try


            For i = 1 To 13
                SendField(i).Left = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(SendField(i - 1).Left) + 370)
                D(i).Left = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(D(i - 1).Left) + 370)
                D(i).Text = "D" & i
            Next i
            SendField(14).Left = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(SendField(13).Left) + 600)
            D(14).Left = SendField(14).Left
            D(14).Text = "T0"
            SendField(15).Left = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(SendField(14).Left) + 370)
            D(15).Left = SendField(15).Left
            D(15).Text = "T1"

            SendField(16).Left = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(SendField(15).Left) + 600)
            D(16).Left = SendField(16).Left
            D(16).Text = "B0"
            SendField(17).Left = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(SendField(16).Left) + 370)
            D(17).Left = SendField(17).Left
            D(17).Text = "B1"
            SendField(18).Left = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(SendField(17).Left) + 370)
            D(18).Left = SendField(18).Left
            D(18).Text = "B2"
            SendField(19).Left = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(SendField(18).Left) + 370)
            D(19).Left = SendField(19).Left
            D(19).Text = "TB"

            SendField(20).Left = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(SendField(19).Left) + 600)
            D(20).Left = SendField(20).Left
            D(20).Text = "R0"
            SendField(21).Left = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(SendField(20).Left) + 370)
            D(21).Left = SendField(21).Left
            D(21).Text = "R1"
            SendField(22).Left = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(SendField(21).Left) + 370)
            D(22).Left = SendField(22).Left
            D(22).Text = "R2"

            SendField(23).Left = VB6.TwipsToPixelsX(VB6.PixelsToTwipsX(SendField(22).Left) + 600)
            D(23).Left = SendField(23).Left
            D(23).Text = "S"
        Catch ex As Exception

        End Try

        RF = LoadMdb()




        SelectedRow = UpdateStationSw(True, RF)



        MainLoad = True
        Try
            StationSw.Row = SelectedRow
        Catch ex As Exception

        End Try



        mMixer.Volume(AudioMixer.SelectedIndex) = CInt(Loudness.Text)
    End Sub

    Private Function LoadMdb() As Integer

        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        Dim LPTstr As String

        Dim RF As Integer
        Dim sNames() As String
        Dim i As Integer
        Dim AudioCardSelectedIndex As Short
        Dim AudioMixerSelectedIndex As Short
        Dim LoudNessValue As Short
        Dim Temp As String

        StationSw.Cols.Count = 3
        StationSw.Rows.Count = 1
        StationSw.Cols.Item(0).Width = 27
        StationSw.Cols.Item(1).Width = 100

        Bands.Cols.Count = 6
        Bands.Rows.Count = 3
        Bands.Cols.Item(0).Width = 0
        Bands.Cols.Item(1).Width = 90
        Bands.Cols.Item(2).Width = 90
        Bands.Cols.Item(3).Width = 90
        Bands.Cols.Item(4).Width = 80
        Bands.Cols.Item(5).Width = 30

        Bands.Cols.Item(0).AllowResizing = False
        Bands.Cols.Item(1).AllowResizing = False
        Bands.Cols.Item(2).AllowResizing = False
        Bands.Cols.Item(3).AllowResizing = False
        Bands.Cols.Item(4).AllowResizing = False
        Bands.Cols.Item(5).AllowResizing = False

        Bands.Cols.Item(0).AllowSorting = False
        Bands.Cols.Item(1).AllowSorting = False
        Bands.Cols.Item(2).AllowSorting = False
        Bands.Cols.Item(3).AllowSorting = False
        Bands.Cols.Item(4).AllowSorting = False
        Bands.Cols.Item(5).AllowSorting = False

        Bands.Cols.Item(1).AllowEditing = False

        Bands.Cols.Item(5).DataType = GetType(Boolean)
        Bands.Cols.Item(4).ComboList = "1|5|9|10|25|50|100"

        Me.Bands.SetData(0, 1, "BandName")
        Me.Bands.SetData(0, 2, "LowRF")
        Me.Bands.SetData(0, 3, "HighRF")
        Me.Bands.SetData(0, 4, "StepNet")
        Me.Bands.SetData(0, 5, "Use")

        SetupGroup.Left = 8
        SetupGroup.Top = 100
        SetupGroup.Width = 740
        SetupGroup.Height = 300
        StationSw.Left = 8
        StationSw.Top = 100
        StationSw.Width = 740
        StationSw.Height = 300
        StationSw.Cols.Item(2).Width = StationSw.Width - 150

        StationDown.Left = 8
        StationDown.Top = 408
        Station.Left = 48
        Station.Top = 408
        StationUp.Left = 131
        StationUp.Top = 408
        ListDown.Left = 192
        ListDown.Top = 408
        List.Left = 232
        List.Top = 408
        ListUp.Left = 282
        ListUp.Top = 408
        StepDown.Left = 344
        StepDown.Top = 408
        Step_Renamed.Left = 384
        Step_Renamed.Top = 408
        StepUp.Left = 440
        StepUp.Top = 408


        Setup.Left = 496
        Setup.Top = 408
        On_Renamed.Left = 576
        On_Renamed.Top = 408
        Off.Left = 634
        Off.Top = 408
        Exit_Renamed.Left = 689
        Exit_Renamed.Top = 408

        RegionLbl.Left = 10
        RegionLbl.Top = 70
        CityLbl.Left = 10
        CityLbl.Top = 100

        RegionBox.Left = 95
        RegionBox.Top = 70

        CityBox.Left = 95
        CityBox.Top = 100

        Bands.Left = 10
        Bands.Top = 140

        Bands.Width = 385
        Bands.Height = 65


        Band1.Left = 1
        Band1.Top = 6
        Band1.Height = 45
        Band1.Width = 60

        Band2.Left = 1
        Band2.Top = 52
        Band2.Height = 44
        Band2.Width = 60

        AudioCard.Top = 70
        AudioCard.Left = 510
        AudioCard.Width = 220

        AudioCardLbl.Top = 70
        AudioCardLbl.Left = 420

        AudioMixer.Top = 100
        AudioMixer.Left = 510
        AudioMixer.Width = 220
        AudioDeviceLbl.Top = 100
        AudioDeviceLbl.Left = 420

        Loudness.Top = 130
        Loudness.Left = 510
        Loudness.Width = 220
        LoudNessLbl.Top = 130
        LoudNessLbl.Left = 420

        LPTAdres.Top = 220
        LPTAdres.Left = 510
        LPTAdres.Width = 220
        LptAdressLbl.Top = 220
        LptAdressLbl.Left = 420

        DelayBitValue.Top = 190
        DelayBitValue.Left = 510
        DelayBitValue.Width = 220
        DelayBitlbl.Top = 190
        DelayBitlbl.Left = 420

        DelayMuteValue.Top = 160
        DelayMuteValue.Left = 510
        DelayMuteValue.Width = 220
        DelayMutelbl.Top = 160
        DelayMutelbl.Left = 420

        CeBit.Top = 250
        CeBit.Left = 510
        CElbl.Top = 250
        CElbl.Left = 480

        ClBit.Top = 250
        ClBit.Left = 587
        CLlbl.Top = 250
        CLlbl.Left = 557

        DataBit.Top = 250
        DataBit.Left = 690
        DATAlbl.Top = 250
        DATAlbl.Left = 640

        For i = 0 To 7
            Me.CeBit.Items.Add("D" & i)
            Me.ClBit.Items.Add("D" & i)
            Me.DataBit.Items.Add("D" & i)
        Next i

        MdbPath = System.Environment.CurrentDirectory & "\FMAvtoData (2.x).mdb"
        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_SQL = "SELECT * FROM Bands"
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset

        DATA_MAIN_REC.AbsolutePosition = 0
        Fm1Name = DATA_MAIN_REC.Fields("BandName").Value
        LowRfFm1 = DATA_MAIN_REC.Fields("LowRf").Value
        HighRfFm1 = DATA_MAIN_REC.Fields("HighRf").Value
        StepNetFm1 = DATA_MAIN_REC.Fields("StepNet").Value
        Fm1Set = DATA_MAIN_REC.Fields("Use").Value

        DATA_MAIN_REC.MoveNext()
        Fm2Name = DATA_MAIN_REC.Fields("BandName").Value
        LowRfFm2 = DATA_MAIN_REC.Fields("LowRf").Value
        HighRfFm2 = DATA_MAIN_REC.Fields("HighRf").Value
        StepNetFm2 = DATA_MAIN_REC.Fields("StepNet").Value
        Fm2Set = DATA_MAIN_REC.Fields("Use").Value

        Me.Bands.SetData(1, 1, Fm1Name)
        Me.Bands.SetData(1, 2, LowRfFm1)
        Me.Bands.SetData(1, 3, HighRfFm1)
        Me.Bands.SetData(1, 4, StepNetFm1)
        Me.Bands.SetData(1, 5, Fm1Set)

        Me.Bands.SetData(2, 1, Fm2Name)
        Me.Bands.SetData(2, 2, LowRfFm2)
        Me.Bands.SetData(2, 3, HighRfFm2)
        Me.Bands.SetData(2, 4, StepNetFm2)
        Me.Bands.SetData(2, 5, Fm2Set)


        If Fm1Set = True Then
            Band1.BackColor = Color.DeepSkyBlue
        Else
            Band1.BackColor = Color.FromArgb(255, 236, 233, 216)
        End If

        If Fm2Set = True Then
            Band2.BackColor = Color.DeepSkyBlue
        Else
            Band2.BackColor = Color.FromArgb(255, 236, 233, 216)
        End If

        DATA_SQL = "SELECT * FROM Seting"
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        Region = DATA_MAIN_REC.Fields("Region").Value
        City = DATA_MAIN_REC.Fields("City").Value
        LPTstr = DATA_MAIN_REC.Fields("LPT").Value
        If LPTstr = "&H378" Then
            LPTPort = 888
        ElseIf LPTstr = "&H278" Then
            LPTPort = 632
        ElseIf LPTstr = "&H3BC" Then
            LPTPort = 902
        End If
        DelayBit = CInt(DATA_MAIN_REC.Fields("DelayBit").Value)
        DelayBitValue.Text = DelayBit
        DelayMute = CInt(DATA_MAIN_REC.Fields("DelayMute").Value)
        DelayMuteValue.Text = DelayMute

        CeBit.SelectedIndex = CInt(DATA_MAIN_REC.Fields("CE").Value)
        DataBit.SelectedIndex = CInt(DATA_MAIN_REC.Fields("DATA").Value)
        ClBit.SelectedIndex = CInt(DATA_MAIN_REC.Fields("CL").Value)

        Adjust = CInt(DATA_MAIN_REC.Fields("Adj").Value)

        RF = CInt(DATA_MAIN_REC.Fields("StationSw").Value)
        AudioCardSelectedIndex = CInt(DATA_MAIN_REC.Fields("AudioCard").Value)
        AudioMixerSelectedIndex = CInt(DATA_MAIN_REC.Fields("AudioDevice").Value)
        LoudNessValue = CInt(DATA_MAIN_REC.Fields("Loudness").Value)

        DATA_SQL = "SELECT Region FROM Stations GROUP BY Region ORDER BY Region"

        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset

        Me.RegionBox.Items.Clear()
        While DATA_MAIN_REC.EOF = False
            If IsDBNull(DATA_MAIN_REC.Fields("Region").Value) = False Then
                Me.RegionBox.Items.Add(DATA_MAIN_REC.Fields("Region").Value)
            End If
            DATA_MAIN_REC.MoveNext()
        End While
        Me.RegionBox.SelectedText = Region

        DATA_SQL = "SELECT City FROM Stations where Region ='" & Region & "' GROUP BY City ORDER BY City"
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset

        While DATA_MAIN_REC.EOF = False
            Me.CityBox.Items.Add(DATA_MAIN_REC.Fields("City").Value)
            DATA_MAIN_REC.MoveNext()
        End While
        Me.CityBox.SelectedText = City
        DATA_MAIN.Close()

        For i = 0 To mMixer.EnumSndDevices(sNames) '    
            Me.AudioCard.Items.Add(sNames(i))
        Next
        Try
            AudioCard.SelectedIndex = AudioCardSelectedIndex
        Catch ex As Exception

        End Try

        Call mMixer.OpenMixer(AudioCard.SelectedIndex)
        AudioMixer.Items.Clear()
        For i = 0 To 15
            If Len(mMixer.uMixerControls(i).szName) > 0 Then
                Select Case (i)
                    Case (0)
                        Temp = "SPEAKER"
                    Case (1)
                        Temp = "LINEIN"
                    Case (2)
                        Temp = "MICROPHONE"
                    Case (3)
                        Temp = "SYNTHESIZER"
                    Case (4)
                        Temp = "COMPACTDISC"
                    Case (5)
                        Temp = "WAVEOUT"
                    Case (6)
                        Temp = "TELEPHONE"
                    Case (7)
                        Temp = "UNDEFINED"
                    Case (8)
                        Temp = "SPEAKER_MUTE"
                    Case (9)
                        Temp = "LINEIN_MUTE"
                    Case (10)
                        Temp = "MICROPHONE_MUTE"
                    Case (11)
                        Temp = "SYNTHESIZER_MUTE"
                    Case (12)
                        Temp = "COMPACTDISC_MUTE"
                    Case (13)
                        Temp = "WAVEOUT_MUTE"
                    Case (14)
                        Temp = "TELEPHONE_MUTE"
                    Case (15)
                        Temp = "UNDEFINED_MUTE"
                End Select

                Me.AudioMixer.Items.Add(Temp & "/" & mMixer.uMixerControls(i).szName & "(" & i & ")")
            End If
        Next i
        Try
            Me.AudioMixer.SelectedIndex = AudioMixerSelectedIndex
        Catch ex As Exception

        End Try

        For i = 0 To 100 Step 5

            Me.Loudness.Items.Add(i)

        Next i
        Try
            Me.Loudness.SelectedText = LoudNessValue
        Catch ex As Exception

        End Try
        LPTAdres.Items.Add("LPT1(H378)")
        LPTAdres.Items.Add("LPT2(H278)")
        LPTAdres.Items.Add("LPT3(H3BC)")

        If LPTstr = "&H378" Then
            LPTAdres.SelectedIndex = 0
        ElseIf LPTstr = "&H278" Then
            LPTAdres.SelectedIndex = 1
        ElseIf LPTstr = "&H3BC" Then
            LPTAdres.SelectedIndex = 2
        End If

        Return RF
    End Function
    Private Function UpdateStationSw(Optional ByVal FirstLoad As Boolean = False, Optional ByVal RF As Integer = 0) As Integer
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        Dim i As Integer
        Dim SelectedRow As Integer
        Dim OldRf As Integer
        StationSw.Rows.Count = 0
        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        If Fm1Set = True And Fm2Set = True Then
            If City = "*" Then
                DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' order by StationFr"
            Else
                DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and City ='" & City & "' order by StationFr"
            End If
        ElseIf Fm1Set = True And Fm2Set = False Then
            If City = "*" Then
                DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and BandName ='" & Fm1Name & "' order by StationFr"
            Else
                DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and City ='" & City & "' and BandName ='" & Fm1Name & "' order by StationFr"
            End If
        ElseIf Fm1Set = False And Fm2Set = True Then
            If City = "*" Then
                DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and BandName ='" & Fm2Name & "' order by StationFr"
            Else
                DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and City ='" & City & "' and BandName ='" & Fm2Name & "' order by StationFr"
            End If
        ElseIf Fm1Set = False And Fm2Set = False Then
            DATA_MAIN.Close()
            Region_Renamed.Text = Region & " " & City & " (" & 0 & ")"
            Exit Function
        End If


        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        StationSw.Clear(C1.Win.C1FlexGrid.ClearFlags.Content)
        While DATA_MAIN_REC.EOF = False
            If i = 0 Or OldRf <> CInt(DATA_MAIN_REC.Fields("StationFr").Value) Then
                StationSw.Rows.Add(1)
                Me.StationSw.SetData(i, 0, i + 1)
                If FirstLoad = True Then
                    If RF = CInt(DATA_MAIN_REC.Fields("StationFr").Value) Then
                        SelectedRow = i
                    End If
                End If
                OldRf = CInt(DATA_MAIN_REC.Fields("StationFr").Value)
                Me.StationSw.SetData(i, 1, DATA_MAIN_REC.Fields("StationFr").Value)
                Me.StationSw.SetData(i, 2, DATA_MAIN_REC.Fields("StationName").Value)
                i = i + 1
            Else
                DATA_MAIN_REC.Delete()
            End If
            DATA_MAIN_REC.MoveNext()
        End While

        DATA_MAIN.Close()

        Region_Renamed.Text = Region & " " & City & " (" & i & ")"
        Return SelectedRow
    End Function
    Private Sub Form1_MouseMove(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.MouseEventArgs) Handles MyBase.MouseMove
        Dim Button As Short = eventArgs.Button \ &H100000
        Dim Shift As Short = System.Windows.Forms.Control.ModifierKeys \ &H10000
        Dim X As Single = VB6.PixelsToTwipsX(eventArgs.X)
        Dim Y As Single = VB6.PixelsToTwipsY(eventArgs.Y)
        Me.StationDown.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.StationUp.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.Exit_Renamed.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.ListDown.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.ListUp.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.Off.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.On_Renamed.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.Setup.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.StepDown.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.StepUp.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
    End Sub
	

	Private Sub Form1_Resize(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Resize
		On Error Resume Next
		Me.Width = VB6.TwipsToPixelsX(11436)
		Me.Height = VB6.TwipsToPixelsY(7260)
	End Sub
	
	Private Sub List_MouseMove(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.MouseEventArgs) Handles List.MouseMove
		Dim Button As Short = eventArgs.Button \ &H100000
		Dim Shift As Short = System.Windows.Forms.Control.ModifierKeys \ &H10000
		Dim X As Single = VB6.PixelsToTwipsX(eventArgs.X)
		Dim Y As Single = VB6.PixelsToTwipsY(eventArgs.Y)
		Me.ListDown.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0s)
		Me.ListUp.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0s)
	End Sub
	
	Private Sub ListDown_MouseMove(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.MouseEventArgs) Handles ListDown.MouseMove
		Dim Button As Short = eventArgs.Button \ &H100000
		Dim Shift As Short = System.Windows.Forms.Control.ModifierKeys \ &H10000
		Dim X As Single = VB6.PixelsToTwipsX(eventArgs.X)
		Dim Y As Single = VB6.PixelsToTwipsY(eventArgs.Y)
		Me.ListDown.ForeColor = System.Drawing.ColorTranslator.FromOle(&HFF0000)
	End Sub
	
	Private Sub ListUp_MouseMove(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.MouseEventArgs) Handles ListUp.MouseMove
		Dim Button As Short = eventArgs.Button \ &H100000
		Dim Shift As Short = System.Windows.Forms.Control.ModifierKeys \ &H10000
		Dim X As Single = VB6.PixelsToTwipsX(eventArgs.X)
		Dim Y As Single = VB6.PixelsToTwipsY(eventArgs.Y)
		Me.ListUp.ForeColor = System.Drawing.ColorTranslator.FromOle(&HFF0000)
	End Sub
	
	Private Sub Off_MouseMove(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.MouseEventArgs) Handles Off.MouseMove
		Dim Button As Short = eventArgs.Button \ &H100000
		Dim Shift As Short = System.Windows.Forms.Control.ModifierKeys \ &H10000
		Dim X As Single = VB6.PixelsToTwipsX(eventArgs.X)
		Dim Y As Single = VB6.PixelsToTwipsY(eventArgs.Y)
		Me.Off.ForeColor = System.Drawing.ColorTranslator.FromOle(&HFF0000)
	End Sub
	
	Private Sub On_Renamed_MouseMove(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.MouseEventArgs) Handles On_Renamed.MouseMove
		Dim Button As Short = eventArgs.Button \ &H100000
		Dim Shift As Short = System.Windows.Forms.Control.ModifierKeys \ &H10000
		Dim X As Single = VB6.PixelsToTwipsX(eventArgs.X)
		Dim Y As Single = VB6.PixelsToTwipsY(eventArgs.Y)
		Me.On_Renamed.ForeColor = System.Drawing.ColorTranslator.FromOle(&HFF0000)
	End Sub
	
	Private Sub Setup_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles Setup.Click
		If SetSetup = False Then
			SetSetup = True
			SetupGroup.Visible = True
			StationSw.Visible = False
		Else
			SetSetup = False
			SetupGroup.Visible = False
			StationSw.Visible = True
		End If
	End Sub
	
	Private Sub Setup_MouseMove(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.MouseEventArgs) Handles Setup.MouseMove
		Dim Button As Short = eventArgs.Button \ &H100000
		Dim Shift As Short = System.Windows.Forms.Control.ModifierKeys \ &H10000
		Dim X As Single = VB6.PixelsToTwipsX(eventArgs.X)
		Dim Y As Single = VB6.PixelsToTwipsY(eventArgs.Y)
		Me.Setup.ForeColor = System.Drawing.ColorTranslator.FromOle(&HFF0000)
	End Sub
	
	Private Sub Station_MouseMove(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.MouseEventArgs) Handles Station.MouseMove
		Dim Button As Short = eventArgs.Button \ &H100000
		Dim Shift As Short = System.Windows.Forms.Control.ModifierKeys \ &H10000
		Dim X As Single = VB6.PixelsToTwipsX(eventArgs.X)
		Dim Y As Single = VB6.PixelsToTwipsY(eventArgs.Y)
		Me.StationDown.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0s)
		Me.StationUp.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0s)
	End Sub
	
	Private Sub StationDown_MouseMove(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.MouseEventArgs) Handles StationDown.MouseMove
		Dim Button As Short = eventArgs.Button \ &H100000
		Dim Shift As Short = System.Windows.Forms.Control.ModifierKeys \ &H10000
		Dim X As Single = VB6.PixelsToTwipsX(eventArgs.X)
		Dim Y As Single = VB6.PixelsToTwipsY(eventArgs.Y)
		Me.StationDown.ForeColor = System.Drawing.ColorTranslator.FromOle(&HFF0000)
	End Sub
	
	Private Sub StationUp_MouseMove(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.MouseEventArgs) Handles StationUp.MouseMove
		Dim Button As Short = eventArgs.Button \ &H100000
		Dim Shift As Short = System.Windows.Forms.Control.ModifierKeys \ &H10000
		Dim X As Single = VB6.PixelsToTwipsX(eventArgs.X)
		Dim Y As Single = VB6.PixelsToTwipsY(eventArgs.Y)
		Me.StationUp.ForeColor = System.Drawing.ColorTranslator.FromOle(&HFF0000)
	End Sub
	
	Private Sub Step_Renamed_MouseMove(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.MouseEventArgs) Handles Step_Renamed.MouseMove
		Dim Button As Short = eventArgs.Button \ &H100000
		Dim Shift As Short = System.Windows.Forms.Control.ModifierKeys \ &H10000
		Dim X As Single = VB6.PixelsToTwipsX(eventArgs.X)
		Dim Y As Single = VB6.PixelsToTwipsY(eventArgs.Y)
		Me.StepDown.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0s)
		Me.StepUp.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0s)
	End Sub
	
	Private Sub StepDown_MouseMove(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.MouseEventArgs) Handles StepDown.MouseMove
		Dim Button As Short = eventArgs.Button \ &H100000
		Dim Shift As Short = System.Windows.Forms.Control.ModifierKeys \ &H10000
		Dim X As Single = VB6.PixelsToTwipsX(eventArgs.X)
		Dim Y As Single = VB6.PixelsToTwipsY(eventArgs.Y)
		Me.StepDown.ForeColor = System.Drawing.ColorTranslator.FromOle(&HFF0000)
	End Sub
	
	Private Sub StepUp_MouseMove(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.MouseEventArgs) Handles StepUp.MouseMove
		Dim Button As Short = eventArgs.Button \ &H100000
		Dim Shift As Short = System.Windows.Forms.Control.ModifierKeys \ &H10000
		Dim X As Single = VB6.PixelsToTwipsX(eventArgs.X)
		Dim Y As Single = VB6.PixelsToTwipsY(eventArgs.Y)
		Me.StepUp.ForeColor = System.Drawing.ColorTranslator.FromOle(&HFF0000)
    End Sub



    Private Sub StationSw_AfterSelChange(ByVal sender As Object, ByVal e As C1.Win.C1FlexGrid.RangeEventArgs) Handles StationSw.AfterSelChange
        Dim Path As String
        Dim FileExists As System.IO.File
        Dim RFstr(0) As String
        Dim RFtxt As String
        Dim RFdbl As Double
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String

        If MainLoad = False Then Exit Sub
        If Off_Tuner = True Then
            Region_Renamed.ForeColor = System.Drawing.ColorTranslator.FromOle(-2147483630)
            RF.ForeColor = System.Drawing.ColorTranslator.FromOle(255)
            StationName.ForeColor = System.Drawing.ColorTranslator.FromOle(16711680)
            Off_Tuner = False
        End If

        RFdbl = StationSw.GetData(StationSw.Row, 1)
        RFdbl = RFdbl / 1000
        Dim qw As String
        Try
            RFtxt = Format(RFdbl, "#.000")
            RFstr = Split(RFtxt, ",")
            RF.Text = RFstr(0) & " " & RFstr(1) & " "
        Catch ex As Exception
            RFtxt = Format(RFdbl, "#.000")
            RFstr = Split(RFtxt, ".")
            RF.Text = RFstr(0) & " " & RFstr(1) & " "
        End Try

        Try
            StationName.Text = StationSw.GetData(StationSw.Row, 2)
        Catch ex As Exception
            StationName.Text = ""
        End Try

        Try
            Path = System.Environment.CurrentDirectory & "\Image\" & StationName.Text & ".gif"
            If FileExists.Exists(Path) = True Then
                Logo.ImageLocation = Path
            Else
                Path = System.Environment.CurrentDirectory & "\Image\" & "_Nonlogo.gif"
            End If
            Logo.ImageLocation = Path
        Catch ex As Exception

        End Try
        CurentRf = CInt(StationSw.GetData(StationSw.Row, 1))
        SetTuner(CurentRf)

        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_SQL = "SELECT * FROM Seting"
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.Edit()
        DATA_MAIN_REC.Fields("StationName").Value = StationName.Text
        DATA_MAIN_REC.Fields("StationSw").Value = CurentRf

        DATA_MAIN_REC.Update()
        DATA_MAIN.Close()

    End Sub


    Private Sub RegionBox_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RegionBox.SelectedIndexChanged
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        Me.CityBox.Items.Clear()
        Region = Me.RegionBox.Text
        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_SQL = "SELECT City FROM Stations where Region ='" & Region & "' GROUP BY City ORDER BY City"
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset

        Me.CityBox.Items.Add("*")
        While DATA_MAIN_REC.EOF = False
            Me.CityBox.Items.Add(DATA_MAIN_REC.Fields("City").Value)
            DATA_MAIN_REC.MoveNext()
        End While



        Try
            Me.CityBox.SelectedIndex = 0
        Catch ex As Exception

        End Try
        City = Me.CityBox.Text
        DATA_SQL = "SELECT * FROM Seting"
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.Edit()
        DATA_MAIN_REC.Fields("Region").Value = Region
        DATA_MAIN_REC.Fields("City").Value = City
        DATA_MAIN_REC.Update()

        DATA_MAIN.Close()
    End Sub

    Private Sub Bands_ValidateEdit(ByVal sender As Object, ByVal e As C1.Win.C1FlexGrid.ValidateEditEventArgs) Handles Bands.ValidateEdit
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String

        If Bands.Col = 2 Then
            If Bands.Row = 1 Then
                LowRfFm1 = Bands.Editor.Text
            ElseIf Bands.Row = 2 Then
                LowRfFm2 = Bands.Editor.Text
            End If
        ElseIf Bands.Col = 3 Then
            If Bands.Row = 1 Then
                HighRfFm1 = Bands.Editor.Text
            ElseIf Bands.Row = 2 Then
                HighRfFm2 = Bands.Editor.Text
            End If
        ElseIf Bands.Col = 4 Then
            If Bands.Row = 1 Then
                StepNetFm1 = Bands.Editor.Text
            ElseIf Bands.Row = 2 Then
                StepNetFm2 = Bands.Editor.Text
            End If
        ElseIf Bands.Col = 5 Then
            If Bands.Row = 1 Then
                Fm1Set = Not (Fm1Set)
            ElseIf Bands.Row = 2 Then
                Fm2Set = Not (Fm2Set)
            End If
            MainLoad = False
            UpdateStationSw()
            MainLoad = True
        End If
        If Fm1Set = True Then
            Band1.BackColor = Color.DeepSkyBlue
        Else
            Band1.BackColor = Color.FromArgb(255, 236, 233, 216)
        End If

        If Fm2Set = True Then
            Band2.BackColor = Color.DeepSkyBlue
        Else
            Band2.BackColor = Color.FromArgb(255, 236, 233, 216)
        End If
        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_SQL = "SELECT * FROM Bands where BandName ='" & Fm1Name & "' "
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.Edit()
        DATA_MAIN_REC.Fields("BandName").Value = Fm1Name
        DATA_MAIN_REC.Fields("LowRf").Value = LowRfFm1
        DATA_MAIN_REC.Fields("HighRf").Value = HighRfFm1
        DATA_MAIN_REC.Fields("StepNet").Value = StepNetFm1
        DATA_MAIN_REC.Fields("Use").Value = Fm1Set
        DATA_MAIN_REC.Update()

        DATA_SQL = "SELECT * FROM Bands where BandName ='" & Fm2Name & "' "
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.Edit()
        DATA_MAIN_REC.Fields("BandName").Value = Fm2Name
        DATA_MAIN_REC.Fields("LowRf").Value = LowRfFm2
        DATA_MAIN_REC.Fields("HighRf").Value = HighRfFm2
        DATA_MAIN_REC.Fields("StepNet").Value = StepNetFm2
        DATA_MAIN_REC.Fields("Use").Value = Fm2Set
        DATA_MAIN_REC.Update()
        DATA_MAIN.Close()


    End Sub
    Private Sub SetTuner(ByVal RF As Integer)
        Dim Divisor As Integer
        Dim StepNet As Integer
        Dim Str As String
        Dim asd(0 To 23) As Short
        Dim i As Short
        Dim R0 As Short
        Dim R1 As Short
        Dim R2 As Short

        If LowRfFm1 <= RF And RF <= HighRfFm1 Then
            StepNet = StepNetFm1
        ElseIf LowRfFm2 <= RF And RF <= HighRfFm2 Then
            StepNet = StepNetFm2
        End If

        Select Case (StepNet)
            Case (1)
                R0 = 1
                R1 = 1
                R2 = 0
            Case (5)
                R0 = 1
                R1 = 1
                R2 = 1
            Case (9)
                R0 = 1
                R1 = 0
                R2 = 1
            Case (10)
                R0 = 1
                R1 = 0
                R2 = 0
            Case (25)
                R0 = 0
                R1 = 1
                R2 = 0
            Case (50)
                R0 = 0
                R1 = 0
                R2 = 1
            Case Else
                R0 = 0
                R1 = 0
                R2 = 0
        End Select

        Divisor = (Adjust + RF) / StepNet
        Str = Bin(Divisor, 14)
        For i = 0 To 13 'D0-D13
            asd(i) = CInt(Mid(Str, 14 - i, 1))
        Next i
        asd(14) = 0 ' T0
        asd(15) = 0 ' T1

        asd(16) = 0 ' B0
        asd(17) = 0 ' B1
        asd(18) = 1 ' B2
        asd(19) = 0 ' TB

        asd(20) = R0 ' R0
        asd(21) = R1 ' R1
        asd(22) = R2 ' R2

        asd(23) = 1 ' S
        For i = 0 To 23
            SendField(i).Text = asd(i)
        Next i

        WriteLPT(asd, LPTPort, DelayBit, CeBit.SelectedIndex, DataBit.SelectedIndex, ClBit.SelectedIndex)
    End Sub
    Private Function Bin(ByRef Number As Integer, ByRef Sign As Short) As String '    
        Dim i As Short
        Dim Remainder As Integer
        Dim dv(Sign) As Short

        dv(Sign) = Number Mod 2
        Remainder = Number
        For i = Sign - 1 To 1 Step -1
            Remainder = Remainder \ 2
            dv(i) = System.Math.Abs(CInt(Remainder Mod 2 > 0))
        Next i
        For i = 1 To Sign
            Bin = Bin & dv(i)
        Next i
        Return Bin
    End Function

    Private Sub StationUp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles StationUp.Click
        If StationSw.Rows.Count > StationSw.Row + 1 Then
            StationSw.Row = StationSw.Row + 1
        Else
            StationSw.Row = 0
        End If
    End Sub

    Private Sub StationDown_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles StationDown.Click
        If StationSw.Row - 1 > 0 Then
            StationSw.Row = StationSw.Row - 1
        Else
            StationSw.Row = StationSw.Rows.Count - 1
        End If
    End Sub

    Private Sub Band1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Band1.Click
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        Fm1Set = Not (Fm1Set)
        If Fm1Set = True Then
            Band1.BackColor = Color.DeepSkyBlue
        Else
            Band1.BackColor = Color.FromArgb(255, 236, 233, 216)
        End If
        MainLoad = False
        UpdateStationSw()
        MainLoad = True
        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_SQL = "SELECT * FROM Bands where BandName ='" & Fm1Name & "' "
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.Edit()
        DATA_MAIN_REC.Fields("Use").Value = Fm1Set
        DATA_MAIN_REC.Update()
        DATA_MAIN.Close()
    End Sub

    Private Sub Band2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Band2.Click
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String

        Fm2Set = Not (Fm2Set)
        If Fm2Set = True Then
            Band2.BackColor = Color.DeepSkyBlue
        Else
            Band2.BackColor = Color.FromArgb(255, 236, 233, 216)
        End If
        MainLoad = False
        UpdateStationSw()
        MainLoad = True
        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_SQL = "SELECT * FROM Bands where BandName ='" & Fm2Name & "' "
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.Edit()
        DATA_MAIN_REC.Fields("Use").Value = Fm2Set
        DATA_MAIN_REC.Update()
        DATA_MAIN.Close()
    End Sub
    Private Sub OffTuner()
        Dim RF As Integer
        Dim Divisor As Integer
        Dim Str As String
        Dim asd(0 To 23) As Short
        Dim i As Short
        Dim R0 As Short
        Dim R1 As Short
        Dim R2 As Short
        Dim StepNet As Integer
        Try
            RF = CurentRf
        Catch ex As Exception
            RF = 101700
        End Try

        If LowRfFm1 <= RF And RF <= HighRfFm1 Then
            StepNet = StepNetFm1
        ElseIf LowRfFm2 <= RF And RF <= HighRfFm2 Then
            StepNet = StepNetFm2
        End If

        Select Case (StepNet)
            Case (1)
                R0 = 1
                R1 = 1
                R2 = 0
            Case (5)
                R0 = 1
                R1 = 1
                R2 = 1
            Case (9)
                R0 = 1
                R1 = 0
                R2 = 1
            Case (10)
                R0 = 1
                R1 = 0
                R2 = 0
            Case (25)
                R0 = 0
                R1 = 1
                R2 = 0
            Case (50)
                R0 = 0
                R1 = 0
                R2 = 1
            Case Else
                R0 = 0
                R1 = 0
                R2 = 0
        End Select
        Try
            Divisor = (Adjust + RF) / StepNet
        Catch ex As Exception
            Divisor = 1124
        End Try

        Str = Bin(Divisor, 14)
        For i = 0 To 13 'D0-D13
            asd(i) = CInt(Mid(Str, 14 - i, 1))
        Next i
        asd(14) = 0 ' T0
        asd(15) = 0 ' T1

        asd(16) = 0 ' B0
        asd(17) = 1 ' B1
        asd(18) = 0 ' B2
        asd(19) = 0 ' TB

        asd(20) = R0 ' R0
        asd(21) = R1 ' R1
        asd(22) = R2 ' R2

        asd(23) = 1 ' S

        For i = 0 To 23
            SendField(i).Text = asd(i)
        Next i

        WriteLPT(asd, LPTPort, DelayBit, CeBit.SelectedIndex, DataBit.SelectedIndex, ClBit.SelectedIndex)
        mMixer.Volume(AudioMixer.SelectedIndex) = 0
    End Sub
    Private Sub Off_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Off.Click
        Dim BackColor As Integer
        BackColor = System.Drawing.ColorTranslator.ToOle(Me.BackColor)

        OffTuner()
        Region_Renamed.ForeColor = System.Drawing.ColorTranslator.FromOle(BackColor + 1)
        RF.ForeColor = System.Drawing.ColorTranslator.FromOle(BackColor + 1)
        StationName.ForeColor = System.Drawing.ColorTranslator.FromOle(BackColor + 1)
        Off_Tuner = True

    End Sub

    Private Sub On_Renamed_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles On_Renamed.Click
        CurentRf = CInt(StationSw.GetData(StationSw.Row, 1))
        mMixer.Volume(AudioMixer.SelectedIndex) = CInt(Loudness.Text)
        Region_Renamed.ForeColor = System.Drawing.ColorTranslator.FromOle(-2147483630)
        RF.ForeColor = System.Drawing.ColorTranslator.FromOle(255)
        StationName.ForeColor = System.Drawing.ColorTranslator.FromOle(16711680)
        SetTuner(CurentRf)
    End Sub

    Private Sub StepUp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles StepUp.Click
        Dim StepNet As Integer
        Dim RFstr(0) As String
        Dim RFtxt As String
        Dim RFdbl As Double
        Dim i As Integer
        If LowRfFm1 <= CurentRf And CurentRf < HighRfFm1 Then
            StepNet = StepNetFm1
        ElseIf LowRfFm2 <= CurentRf And CurentRf <= HighRfFm2 Then
            StepNet = StepNetFm2
        End If
        CurentRf = CurentRf + StepNet

        If LowRfFm1 <= CurentRf And CurentRf <= HighRfFm1 Then
            RFdbl = Int(CurentRf / StepNetFm1)
            CurentRf = Int(RFdbl * StepNetFm1)
        ElseIf LowRfFm2 <= CurentRf And CurentRf <= HighRfFm2 Then
            RFdbl = Int(CurentRf / StepNetFm2)
            CurentRf = Int(RFdbl * StepNetFm2)
        End If

        If CurentRf > HighRfFm2 Then CurentRf = LowRfFm1
        RFdbl = CurentRf
        RFdbl = RFdbl / 1000
        Try
            RFtxt = Format(RFdbl, "#.000")
            RFstr = Split(RFtxt, ",")
            RF.Text = RFstr(0) & " " & RFstr(1) & " "
        Catch ex As Exception
            RFtxt = Format(RFdbl, "#.000")
            RFstr = Split(RFtxt, ".")
            RF.Text = RFstr(0) & " " & RFstr(1) & " "
        End Try

        StationName.Text = ""
        Logo.ImageLocation = System.Environment.CurrentDirectory & "\Image\" & "_Nonlogo.gif"
        For i = 0 To StationSw.Rows.Count - 1
            If StationSw.GetData(i, 1) = CurentRf Then
                StationSw.Row = i
                MemStation.Enabled = False
                Exit Sub
            End If
        Next i
        MemStation.Enabled = True
    End Sub

    Private Sub StepDown_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles StepDown.Click
        Dim StepNet As Integer
        Dim RFstr(0) As String
        Dim RFtxt As String
        Dim RFdbl As Double
        Dim i As Integer
        If LowRfFm1 <= CurentRf And CurentRf <= HighRfFm1 Then
            StepNet = StepNetFm1
        ElseIf LowRfFm2 <= CurentRf And CurentRf <= HighRfFm2 Then
            StepNet = StepNetFm2
        End If
        CurentRf = CurentRf - StepNet
        If LowRfFm1 <= CurentRf And CurentRf <= HighRfFm1 Then
            RFdbl = Int(CurentRf / StepNetFm1)
            CurentRf = Int(RFdbl * StepNetFm1)
        ElseIf LowRfFm2 <= CurentRf And CurentRf <= HighRfFm2 Then
            RFdbl = Int(CurentRf / StepNetFm2)
            CurentRf = Int(RFdbl * StepNetFm2)
        End If
        If CurentRf < LowRfFm1 Then CurentRf = HighRfFm2
        RFdbl = CurentRf
        RFdbl = RFdbl / 1000
        Try
            RFtxt = Format(RFdbl, "#.000")
            RFstr = Split(RFtxt, ",")
            RF.Text = RFstr(0) & " " & RFstr(1) & " "
        Catch ex As Exception
            RFtxt = Format(RFdbl, "#.000")
            RFstr = Split(RFtxt, ".")
            RF.Text = RFstr(0) & " " & RFstr(1) & " "
        End Try
        StationName.Text = ""
        Logo.ImageLocation = System.Environment.CurrentDirectory & "\Image\" & "_Nonlogo.gif"
        For i = 0 To StationSw.Rows.Count - 1
            If StationSw.GetData(i, 1) = CurentRf Then
                StationSw.Row = i
                MemStation.Enabled = False
                Exit Sub
            End If
        Next i
        MemStation.Enabled = True
    End Sub

    Private Sub ListUp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ListUp.Click
        StationSw.TopRow = StationSw.TopRow + 14
        StationSw.Row = StationSw.TopRow
    End Sub

    Private Sub ListDown_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ListDown.Click
        StationSw.TopRow = StationSw.TopRow - 14
        StationSw.Row = StationSw.TopRow
    End Sub

    Private Sub LPTAdres_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LPTAdres.SelectedIndexChanged
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_SQL = "SELECT * FROM Seting "
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.Edit()

        If LPTAdres.Text = "LPT1(H378)" Then
            LPTPort = 888
            DATA_MAIN_REC.Fields("LPT").Value = "&H378"
        ElseIf LPTAdres.Text = "LPT2(H278)" Then
            LPTPort = 632
            DATA_MAIN_REC.Fields("LPT").Value = "&H278"
        ElseIf LPTAdres.Text = "LPT3(H3BC)" Then
            LPTPort = 902
            DATA_MAIN_REC.Fields("LPT").Value = "&H3BC"
        End If
        DATA_MAIN_REC.Update()
        DATA_MAIN.Close()
    End Sub

    Private Sub Loudness_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Loudness.SelectedIndexChanged
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_SQL = "SELECT * FROM Seting "
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.Edit()
        DATA_MAIN_REC.Fields("Loudness").Value = CInt(Loudness.Text)
        DATA_MAIN_REC.Update()
        DATA_MAIN.Close()
        mMixer.Volume(AudioMixer.SelectedIndex) = CInt(Loudness.Text)
    End Sub

    Private Sub AudioCard_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AudioCard.SelectedIndexChanged
        Dim i As Short
        Dim Temp As String
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        Call mMixer.OpenMixer(AudioCard.SelectedIndex)
        AudioMixer.Items.Clear()
        For i = 0 To 15
            If Len(mMixer.uMixerControls(i).szName) > 0 Then
                Select Case (i)
                    Case (0)
                        Temp = "SPEAKER"
                    Case (1)
                        Temp = "LINEIN"
                    Case (2)
                        Temp = "MICROPHONE"
                    Case (3)
                        Temp = "SYNTHESIZER"
                    Case (4)
                        Temp = "COMPACTDISC"
                    Case (5)
                        Temp = "WAVEOUT"
                    Case (6)
                        Temp = "TELEPHONE"
                    Case (7)
                        Temp = "UNDEFINED"
                    Case (8)
                        Temp = "SPEAKER_MUTE"
                    Case (9)
                        Temp = "LINEIN_MUTE"
                    Case (10)
                        Temp = "MICROPHONE_MUTE"
                    Case (11)
                        Temp = "SYNTHESIZER_MUTE"
                    Case (12)
                        Temp = "COMPACTDISC_MUTE"
                    Case (13)
                        Temp = "WAVEOUT_MUTE"
                    Case (14)
                        Temp = "TELEPHONE_MUTE"
                    Case (15)
                        Temp = "UNDEFINED_MUTE"
                End Select

                Me.AudioMixer.Items.Add(Temp & "/" & mMixer.uMixerControls(i).szName & "(" & i & ")")
            End If
        Next i
        AudioMixer.SelectedIndex = 0


        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_SQL = "SELECT * FROM Seting "
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.Edit()
        DATA_MAIN_REC.Fields("AudioCard").Value = AudioCard.SelectedIndex
        DATA_MAIN_REC.Fields("AudioDevice").Value = 0
        DATA_MAIN_REC.Update()
        DATA_MAIN.Close()

    End Sub

    Private Sub AudioMixer_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AudioMixer.SelectedIndexChanged
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String

        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_SQL = "SELECT * FROM Seting "
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.Edit()
        DATA_MAIN_REC.Fields("AudioDevice").Value = AudioMixer.SelectedIndex
        DATA_MAIN_REC.Update()
        DATA_MAIN.Close()
    End Sub
    Private Sub procDE_Disposed(ByVal sender As Object, ByVal e As EventArgs)

        Me.procDE = Nothing

    End Sub

    Overridable Property procDE() As Process
        Get
            Return Me._procDE
        End Get
        Set(ByVal WithEventsValue As Process)
            If (Not Me._procDE Is Nothing) Then
                RemoveHandler Me._procDE.Exited, New EventHandler(AddressOf Me.procDE_Disposed)
                RemoveHandler Me._procDE.Disposed, New EventHandler(AddressOf Me.procDE_Disposed)
            End If
            Me._procDE = WithEventsValue
            If (Not Me._procDE Is Nothing) Then
                AddHandler Me._procDE.Exited, New EventHandler(AddressOf Me.procDE_Disposed)
                AddHandler Me._procDE.Disposed, New EventHandler(AddressOf Me.procDE_Disposed)
            End If
        End Set
    End Property



    Private Sub StationSw_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles StationSw.Click
        If Off_Tuner = True Then
            CurentRf = CInt(StationSw.GetData(StationSw.Row, 1))
            mMixer.Volume(AudioMixer.SelectedIndex) = CInt(Loudness.Text)
            Region_Renamed.ForeColor = System.Drawing.ColorTranslator.FromOle(-2147483630)
            RF.ForeColor = System.Drawing.ColorTranslator.FromOle(255)
            StationName.ForeColor = System.Drawing.ColorTranslator.FromOle(16711680)
            SetTuner(CurentRf)
        End If
    End Sub

    Private Sub CityBox_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CityBox.SelectedIndexChanged
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        Dim SelectedRow As Int16
        City = Me.CityBox.Text
        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_SQL = "SELECT * FROM Seting"
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.Edit()
        DATA_MAIN_REC.Fields("Region").Value = Region
        DATA_MAIN_REC.Fields("City").Value = City
        DATA_MAIN_REC.Update()
        DATA_MAIN.Close()
        MainLoad = False
        SelectedRow = UpdateStationSw(False, 0)
        MainLoad = True
    End Sub

    Private Sub DelayBitValue_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DelayBitValue.TextChanged
        Dim value As Integer
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        Try
            value = CInt(DelayBitValue.Text)
            If value < 0 Then
                value = 0
                DelayBitValue.Text = value
            End If
            If value > 1000 Then
                value = 1000
                DelayBitValue.Text = value
            End If
            DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
            DATA_SQL = "SELECT * FROM Seting"
            DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
            DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
            DATA_MAIN_REC.Edit()
            DATA_MAIN_REC.Fields("DelayBit").Value = value
            DATA_MAIN_REC.Update()
            DATA_MAIN.Close()
            DelayBit = value
        Catch ex As Exception
            If DelayBitValue.Text <> "" Then
                DelayBitValue.Text = 10
            End If
        End Try
    End Sub

    Private Sub DelayMuteValue_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DelayMuteValue.TextChanged
        Dim value As Integer
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        Try
            value = CInt(DelayMuteValue.Text)
            If value < 0 Then
                value = 0
                DelayMuteValue.Text = value
            End If
            If value > 1000 Then
                value = 1000
                DelayMuteValue.Text = value
            End If
            DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
            DATA_SQL = "SELECT * FROM Seting"
            DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
            DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
            DATA_MAIN_REC.Edit()
            DATA_MAIN_REC.Fields("DelayMute").Value = value
            DATA_MAIN_REC.Update()
            DATA_MAIN.Close()
            DelayMute = value
        Catch ex As Exception
            If DelayMuteValue.Text <> "" Then
                DelayMuteValue.Text = 500
            End If
        End Try
    End Sub

    Private Sub CeBit_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CeBit.SelectedIndexChanged
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_SQL = "SELECT * FROM Seting "
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.Edit()
        DATA_MAIN_REC.Fields("CE").Value = CeBit.SelectedIndex
        DATA_MAIN_REC.Update()
        DATA_MAIN.Close()
    End Sub

    Private Sub ClBit_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ClBit.SelectedIndexChanged
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_SQL = "SELECT * FROM Seting "
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.Edit()
        DATA_MAIN_REC.Fields("CL").Value = ClBit.SelectedIndex
        DATA_MAIN_REC.Update()
        DATA_MAIN.Close()
    End Sub

    Private Sub DataBit_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DataBit.SelectedIndexChanged
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_SQL = "SELECT * FROM Seting "
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.Edit()
        DATA_MAIN_REC.Fields("DATA").Value = DataBit.SelectedIndex
        DATA_MAIN_REC.Update()
        DATA_MAIN.Close()
    End Sub

    Private Sub StationSw_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles StationSw.MouseMove
        Me.DelStation.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.MemStation.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.StationDown.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.StationUp.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.Exit_Renamed.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.ListDown.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.ListUp.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.Off.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.On_Renamed.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.Setup.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.StepDown.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.StepUp.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
    End Sub


    Private Sub StationSw_ValidateEdit(ByVal sender As Object, ByVal e As C1.Win.C1FlexGrid.ValidateEditEventArgs) Handles StationSw.ValidateEdit
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        Dim SearchStr As String
        Dim RFNew As Single
        Dim RFNewUpdate As Boolean
        Dim RFOld As Integer
        SearchStr = StationSw.GetData(StationSw.Row, 1)
        RFOld = CInt(SearchStr)
        If Fm1Set = True And Fm2Set = True Then
            If City = "*" Then
                DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and StationFr = " & SearchStr & " "
            Else
                DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and City ='" & City & "' and StationFr = " & SearchStr & " "
            End If
        ElseIf Fm1Set = True And Fm2Set = False Then
            If City = "*" Then
                DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and BandName ='" & Fm1Name & "' and StationFr = " & SearchStr & " "
            Else
                DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and City ='" & City & "' and BandName ='" & Fm1Name & "' and StationFr = " & SearchStr & " "
            End If
        ElseIf Fm1Set = False And Fm2Set = True Then
            If City = "*" Then
                DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and BandName ='" & Fm2Name & "' and StationFr = " & SearchStr & " "
            Else
                DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and City ='" & City & "' and BandName ='" & Fm2Name & "' and StationFr = " & SearchStr & " "
            End If
        ElseIf Fm1Set = False And Fm2Set = False Then


            Exit Sub
        End If
        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset

        If StationSw.Col = 1 Then
            RFNew = CInt(StationSw.Editor.Text)

            If RFNew >= LowRfFm1 And RFNew <= HighRfFm1 Then
                RFNew = Int(RFNew / StepNetFm1)
                RFNew = Int(RFNew * StepNetFm1)
                DATA_MAIN_REC.Edit()
                DATA_MAIN_REC.Fields("StationFr").Value = RFNew
                DATA_MAIN_REC.Update()
                RFNewUpdate = True
            ElseIf RFNew >= LowRfFm2 And RFNew <= HighRfFm2 Then
                RFNew = Int(RFNew / StepNetFm2)
                RFNew = Int(RFNew * StepNetFm2)
                DATA_MAIN_REC.Edit()
                DATA_MAIN_REC.Fields("StationFr").Value = RFNew
                DATA_MAIN_REC.Update()
                RFNewUpdate = True
            End If
            If RFNewUpdate = False Then
                StationSw.Editor.Text = RFOld
            Else
                StationSw.Editor.Text = RFNew
            End If
        ElseIf StationSw.Col = 2 Then
            DATA_MAIN_REC.Edit()
            DATA_MAIN_REC.Fields("StationName").Value = StationSw.Editor.Text
            DATA_MAIN_REC.Update()
        End If
        DATA_MAIN.Close()
    End Sub

    Private Sub MemStation_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MemStation.Click
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        Dim BandName As String
        If LowRfFm1 <= CurentRf And CurentRf <= HighRfFm1 Then
            BandName = "FM1"
        ElseIf LowRfFm2 <= CurentRf And CurentRf <= HighRfFm2 Then
            BandName = "FM2"
        End If
        DATA_SQL = "SELECT * FROM Stations"
        DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
        DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
        DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
        DATA_MAIN_REC.AddNew()
        DATA_MAIN_REC.Fields("Region").Value = Region
        DATA_MAIN_REC.Fields("City").Value = City
        DATA_MAIN_REC.Fields("BandName").Value = BandName
        DATA_MAIN_REC.Fields("StationFr").Value = CInt(CurentRf)
        DATA_MAIN_REC.Update()
        DATA_MAIN.Close()
        MemStation.Enabled = False
        MainLoad = False
        Try
            StationSw.Row = UpdateStationSw(True, CurentRf)
        Catch ex As Exception

        End Try

        MainLoad = True
    End Sub

    Private Sub DelStation_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles DelStation.Click
        Dim Ret As Integer
        Dim DATA_MAIN As DAO.Database
        Dim DATA_MAIN_QUERY As DAO.QueryDef
        Dim DATA_MAIN_REC As DAO.Recordset
        Dim DATA_SQL As String
        Dim qry_sel As String
        Dim SearchStr As String
        SearchStr = StationSw.GetData(StationSw.Row, 1)
        Ret = MsgBox("?", MsgBoxStyle.OkCancel)
        If Ret = 1 Then
            If Fm1Set = True And Fm2Set = True Then
                If City = "*" Then
                    DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and StationFr = " & SearchStr & " "
                Else
                    DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and City ='" & City & "' and StationFr = " & SearchStr & " "
                End If
            ElseIf Fm1Set = True And Fm2Set = False Then
                If City = "*" Then
                    DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and BandName ='" & Fm1Name & "' and StationFr = " & SearchStr & " "
                Else
                    DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and City ='" & City & "' and BandName ='" & Fm1Name & "' and StationFr = " & SearchStr & " "
                End If
            ElseIf Fm1Set = False And Fm2Set = True Then
                If City = "*" Then
                    DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and BandName ='" & Fm2Name & "' and StationFr = " & SearchStr & " "
                Else
                    DATA_SQL = "SELECT * FROM Stations WHERE Region ='" & Region & "' and City ='" & City & "' and BandName ='" & Fm2Name & "' and StationFr = " & SearchStr & " "
                End If
            ElseIf Fm1Set = False And Fm2Set = False Then


                Exit Sub
            End If
            DATA_MAIN = DAODBEngine.OpenDatabase(MdbPath)
            DATA_MAIN_QUERY = DATA_MAIN.CreateQueryDef(qry_sel, DATA_SQL)
            DATA_MAIN_REC = DATA_MAIN_QUERY.OpenRecordset
            DATA_MAIN_REC.Delete()
            DATA_MAIN.Close()
            MainLoad = False
            UpdateStationSw()
            MainLoad = True
            Me.DelStation.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        End If

    End Sub

    Private Sub MemStation_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles MemStation.MouseMove
        If MemStation.Enabled = True Then
            Me.MemStation.ForeColor = System.Drawing.ColorTranslator.FromOle(&HFF0000)
        End If
    End Sub

    Private Sub DelStation_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles DelStation.MouseMove
        Me.DelStation.ForeColor = System.Drawing.ColorTranslator.FromOle(&HFF0000)
    End Sub



    Private Sub group_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles group.MouseMove
        Me.DelStation.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.MemStation.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
    End Sub

    Private Sub Logo_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Logo.MouseMove
        Me.DelStation.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
        Me.MemStation.ForeColor = System.Drawing.ColorTranslator.FromOle(&H0S)
    End Sub
End Class
