<?php

require_once('HTTPUtility.php');

// Helper func: returns HTML-encoded variable
// --------------------------------------------------------------------------------------------------------------------
function ReturnHTMLVar($var, $replace_linebreaks = true)
{
	$var = htmlspecialchars($var);
	if ($replace_linebreaks)
	{
		$var = str_replace("\r\n", "<br/>", $var);
		$var = str_replace("\r", "<br/>", $var);
		$var = str_replace("\n", "<br/>", $var);
	}
	return $var;
}

// Helper func: outputs HTML-encoded variable
// --------------------------------------------------------------------------------------------------------------------
function OutputHTMLVar($var, $replace_linebreaks = true)
{
	echo '"'.ReturnHTMLVar($var, $replace_linebreaks).'"';
}

// Helper func: returns variable from POST, if it exists
// --------------------------------------------------------------------------------------------------------------------
function ReturnPOSTVar($varname, $replace_linebreaks = true)
{
	if (isset($_POST[$varname]))
		return ReturnHTMLVar(refine_post($_POST[$varname]), $replace_linebreaks);
	else
		return '';
}

/// <summary>
/// Генерирует HTML код для отображения SELECT-списка.
/// </summary>
/// <param name="values">Список значений.</param>
/// <param name="name">Название списка.</param>
/// <param name="valueName">Ключ массива values под которым содержатся значения элементов списка.</param>
/// <param name="valueKey">Ключ массива values под которым содержатся ключи элементов списка.</param>
/// <param name="defaultKey">Ключ элемента списка, который будет выбран по умолчанию.</param>
/// <param name="additional">Дополнительные атрибуты тега SELECT.</param>
/// <returns>HTML код для отображения SELECT-списка</returns>
function ReturnSelectList($values, $name, $valueName, $valueKey, $defaultKey =null, $additional ='')
{
	$result = '<select name="' . ReturnHTMLVar($name) . '" ' . $additional . ' >';
	foreach ($values as $value)
	{
		$result .= '<option ';
		if ($defaultKey == $value[$valueKey])
		{
			$result .= 'selected="selected" ';
		}
		$result .= 'value="' . ReturnHTMLVar($value[$valueKey]) . '">' . ReturnHTMLVar($value[$valueName]) . '</option>';
	}
	$result .= '</select>';

	return $result;
}

/// <summary>
/// Генерирует слово определяющее истину или ложь в общеупотребимой форме.
/// </summary>
/// <param name="var">Перменная содержащая значение true или false</param>
/// <returns>Слово определяющее истину или ложь в общеупотребимой форме.</returns>
function ReturnBoolean($var)
{
	if ((bool)$var == true)
	{
		return 'Да';
	}
	else
	{
		return 'Нет';
	}
}

/// <summary>
/// Генерирует "хлебные крошки".
/// </summary>
/// <param name="breadcrumb">Массив содержащий значения "хлебных крошек", url - адрес, name - заголовок.</param>
/// <param name="separator">Разделитель по умолчанию " | "</param>
/// <returns>html код для отображения хлебных крошек.</returns>
function ReturnBreadcrumb($breadcrumb, $separator =' | ')
{
	if (!is_array($breadcrumb))
	{
		throw new Exception('В качестве параметра breadcrumb необходимо передать массив.');
	}

	$html = '';

	if (count($breadcrumb) > 0)
	{
		foreach ($breadcrumb as $crumb)
		{
			$html .= '<a title="Вернуться к ' . ReturnHTMLVar($crumb['name']) . '" href="' . ReturnHTMLVar($crumb['url']) . '">' . ReturnHTMLVar($crumb['name']) . '</a>' . $separator;
		}

		$html = substr($html, 0, strlen($html) - strlen($separator));
	}

	return $html;
}

// Helper func: returns checkbox input
// --------------------------------------------------------------------------------------------------------------------
function ReturnCheckbox($checked, $name, $label, $value = 1)
{
	if($checked)
		$checked = ' checked="checked"';
	else
		$checked = '';

	return '<input type="checkbox" name="'.ReturnHTMLVar($name).'" value="'.ReturnHTMLVar($value).'"'.$checked."/>$label";
}

// Helper func: outputs checkbox input
// --------------------------------------------------------------------------------------------------------------------
function OutputCheckbox($checked, $name, $label, $value = 1)
{
	echo ReturnCheckbox($checked, $name, $label, $value);
}

// Helper func: returns array of checkboxes
// --------------------------------------------------------------------------------------------------------------------
function ReturnCheckboxes_Basic($name, $items, $checkeditems, $cols = 1, $show_buttons = 1)
{
	if ((is_array($items)) && (count($items) > 0))
	{
		$i = 0;
		$elements_id = 'checkboxes_'.uniqid();
		$res = '<table id="'.$elements_id.'" border="0" cellspacing="0" cellpadding="2">';
		foreach($items as $item_key => $item_value)
		{
			if ((is_array($checkeditems)) && (in_array($item_key, $checkeditems)))
				$checked = true;
			else
				$checked = false;

			if ($i % $cols == 0)
			{
				if ($i > 0)
					$res .= CRLF.'</tr>';
				$res .= CRLF.'<tr>'.CRLF;
			}
			$res .= '<td>';
			$res .= ReturnCheckbox($checked, $name.'[]', $item_value, $item_key);
			$res .= '</td>';

			$i++;
		}
		$res .= CRLF.'</tr>'.CRLF;

		if ($show_buttons)
		{
			$res .= <<<EOD
<tr>
<td colspan="$cols">
<input type="button" value="Выбрать все" style="width: 10em;" onclick="javascript:check_all_elements(document.getElementById('$elements_id'), 1);"/><br/>
<input type="button" value="Сбросить все" style="width: 10em;" onclick="javascript:check_all_elements(document.getElementById('$elements_id'), 0);"/>
</td>
</tr>
EOD;
		}
		$res .= '</table>';
		return $res;
	}
}

// Helper func: outputs array of checkbox input
// --------------------------------------------------------------------------------------------------------------------
function OutputCheckboxes_Basic($name, $items, $checkeditems, $cols = 1, $show_buttons = 1)
{
	echo ReturnCheckboxes_Basic($name, $items, $checkeditems, $cols, $show_buttons);
}

// Helper func: outputs array of checkboxes
// --------------------------------------------------------------------------------------------------------------------
function OutputCheckboxes($name, $items, $key, $value, $checkeditems, $cols = 1)
{
	$conv = array();
	foreach($items as $item)
	{
		eval('$item_key = $item->'.$key.';');
		eval('$item_value = $item->'.$value.';');

		$conv[$item_key] = $item_value;
	}
	OutputCheckboxes_Basic($name, $conv, $checkeditems, $cols);
}

// Helper func: returns select
// --------------------------------------------------------------------------------------------------------------------
function ReturnSelect_Basic($name, $items, $selected_key, $add = '')
{
	if ((is_array($items)) && (count($items) > 0))
	{
		$name = ReturnHTMLVar($name);
		$res = '<select id="'.$name.'" name="'.$name.'"'.$add.'>';
		foreach($items as $item_key => $item_value)
		{
			if ($item_key == $selected_key)
				$selected = ' selected="selected"';
			else
				$selected = '';

			$res .= '<option value="'.ReturnHTMLVar($item_key)."\"$selected>".ReturnHTMLVar($item_value).'</option>';
		}
		$res .= '</select>';
	}
	return $res;
}

// Helper func: outputs select
// --------------------------------------------------------------------------------------------------------------------
function OutputSelect_Basic($name, $items, $selected_key, $add = '')
{
	echo ReturnSelect_Basic($name, $items, $selected_key, $add);
}

// Helper func: outputs select
// --------------------------------------------------------------------------------------------------------------------
function OutputSelect($name, $items, $key, $value, $selected_key, $add = '')
{
	$conv = array();
	foreach($items as $item)
	{
		eval('$item_key = $item->'.$key.';');
		eval('$item_value = $item->'.$value.';');

		$conv[$item_key] = $item_value;
	}
	OutputSelect_Basic($name, $conv, $selected_key, $add);
}

?>