<?php

require_once('Config_Path.php');

// Helper func: refines escaped POST variable
// --------------------------------------------------------------------------------------------------------------------
function refine_post($var)
{
  if ((get_magic_quotes_gpc() == 1) && (defined('ALREADY_ESCAPED') != true))
  {
	  if (is_array($var))
	  {
		  $res = array();
		  foreach($var as $key => $val)
		  	$res[$key] = stripslashes($val);
		  return $res;
	  }
	  else
    	return stripslashes($var);
  }
  else
    return $var;
}

// Helper func: clears all POST variables
// --------------------------------------------------------------------------------------------------------------------
function clear_post()
{
  foreach(array_keys($_POST) as $key)
		unset($_POST[$key]);
}

/// <summary>
/// Получает "очищенное" значение переменной из массива $_POST.
/// Если значение не найдено, возвращает значение по умолчанию
/// </summary>
/// <param name="varName">Название переменной из массива $_POST.</param>
/// <param name="default">Значение по умолчанию, которое будет возвращено в случае, если переменная не была найдена.</param>
/// <returns>"Очищенное" значение пемеренной из массива $_POST.</returns>
function GetPostVarOrDefault($varName, $default ='')
{
	if (isset($_POST[$varName]))
	{
		return refine_post($_POST[$varName]);
	}
	else
	{
		return $default;
	}
}

// Helper func: build url
// --------------------------------------------------------------------------------------------------------------------
function BuildURL($urlprefix, $params)
{
	$res = $urlprefix;
	if (is_null($res))
		$res = '';

	foreach($params as $name => $val)
	{
		if (is_array($val))
		{
			$name .= '[]';
			foreach($val as $array_val)
			{
				if (strpos($res, '?') !== false)
					$res .= '&amp;';
				else
					$res .= '?';

				$res .= urlencode($name);
				$res .= '='.urlencode($array_val);
			}
		}
		else
		{
			if (strpos($res, '?') !== false)
				$res .= '&amp;';
			else
				$res .= '?';

			$res .= urlencode($name);
			if ($val)
			{
				$res .= '='.urlencode($val);
			}
		}
	}
	return $res;
}

// Helper func: absolute url from relative
// --------------------------------------------------------------------------------------------------------------------
function GetURLFromRelative($relative_url)
{
	return 'http://'.rtrim($_SERVER['HTTP_HOST'], '/').SITE_PATH.ltrim($relative_url, '/');
}

// Helper func: returns all headers
// --------------------------------------------------------------------------------------------------------------------
function emu_getallheaders()
{
	$headers = array();
	foreach($_SERVER as $h=>$v)
		if(ereg('HTTP_(.+)',$h,$hp))
			$headers[strtoupper($hp[1])] = $v;
	return $headers;
}

?>