<?php

/// <summary>
/// Позиция GPS
/// </summary>
class Position extends DALEntity
{
	public $Id;
	public $Latitude;
	public $Longitude;
	public $Speed;
	public $ReportedDateTime;
	public $SavedDateTime;

	const Key = 'Id';
	const KeyNewValue = -1;

	function get_Key()
	{
		return Position::Key;
	}

	function get_KeyNewValue()
	{
		return Position::KeyNewValue;
	}

	function get_Table()
	{
		return 'Positions';
	}

	function __construct()
	{
		$this->Id = Position::KeyNewValue;
	}

	/// <summary>
	/// Сохраняет объект в базу
	/// </summary>
	function Save()
	{
		$id = (integer)$this->Id;

		if ($id == Position::KeyNewValue)
		{
			// Проверяем данные

			// Номер УЗ
			$lat = (float)$this->Latitude;
			$lon = (float)$this->Longitude;

			if (!is_null($this->Speed))
				$speed = (float)$this->Speed;
			else
				$speed = 'NULL';

			// Подготавливаем запрос
			$q = "INSERT INTO Positions(Latitude, Longitude, Speed, SavedDateTime) VALUES($lat, $lon, $speed, UTC_TIMESTAMP());";

			// Сохраняем объект в БД
			$this->ExecuteQuery($q);
			if (!is_null($this->_error))
				return;

			$this->Id = mysqli_insert_id($GLOBALS['link']);
		}
		else
		{
			throw new Exception('Not supported');
		}
	}

	/// <summary>
	/// Загружает детальную информацию об объекте
	/// </summary>
	function Load()
	{
		$id = (integer)$this->Id;
		if ($id == Position::KeyNewValue)
			$q = "SELECT Id, Latitude, Longitude, Speed, SavedDateTime FROM Positions ORDER BY Id DESC LIMIT 1";

		$res = $this->ExecuteQuery($q);
		if (!is_null($this->_error))
			return;

		if ($row = mysqli_fetch_assoc($res))
		{
			$this->BindData($row);
		}
		else
			$this->_error = new Error('Позиция не найдена');
	}

	/// <summary>
	/// Удаляет объект из базы
	/// </summary>
	function Delete()
	{
		/*$id = (integer)$this->Id;
		$q = "DELETE FROM Positions WHERE Id = $id";

		// Выполняем запрос
		$this->ExecuteQuery($q);

		if ((!is_null($this->_error)) && (mysqli_errno($GLOBALS['link']) == 1451))
			$this->_error = new Error('Невозможно удалить объект из-за связей с другими данными. Попробуйте заблокировать');
		else if (mysqli_affected_rows($GLOBALS['link']) == 0)
			$this->_error = new Error('Удаляемый объект не найден');*/
	}
}

?>