<?php
	require_once('.php');
	require_once('system/Error/.php');

	/// <summary>
	/// Класс реализующий перечисление.
	/// </summary>
	class Enum extends Entity
	{
		/// <summary>
		/// Текущее значение перечисления.
		/// </summary>
		private $_value;

		/// <summary>
		/// Список возможных значений перечисления.
		/// </summary>
		private $_values;

		/// <summary>
		/// Конструктор класса.
		/// </summary>
		function __construct()
		{
			$this->_values = array();

			// Получаем поля класса.
			$values = get_object_vars($this);
			foreach ($values as $valueName => $value)
			{
				// Приводим названия полей к нужному
				// нам формату и добавляем их в список.
				$valueName = ucfirst(ltrim($valueName, '_'));
				$this->_values[$valueName] = $value;
			}

			// Устанавливаем значение по умолчанию.
			if (count($this->_values) > 0)
			{
				$keys = array_keys($this->_values);
				$this->_value = $keys[0];
			}
			else
			{
				$this->_value = null;
			}
		}

		/// <summary>
		/// Метод вызывается при попытке считать значения перечисления.
		/// </summary>
		/// <param name="name">Название значения.</param>
		/// <returns>Значение перечисления.</returns>
		function __get($name)
		{
			// В случае если пользователь хочет получить текущее значение.
			if ($name == 'Value')
			{
				$name = $this->_value;
			}

			// Ищем необходимое значение перечисления.
			if (isset($this->_values[$name]))
			{
				$result = $this->_values[$name];
			}
			else
			{
				$result = new ArgumentError('Значение "' . $name . '" не найдено в перечислении "' . get_class($this) . '"', 'name');
			}

			return $result;
		}

		/// <summary>
		/// Метод вызывается при попытке новое значение перечисления.
		/// </summary>
		/// <param name="name">Название свойства.</param>
		/// <param name="value">Новое значение, которое должно установиться перечислению.</param>
		function __set($name, $value)
		{
			// Название свойства всгде должно быть, Value.
			if ($name == 'Value')
			{
				// Ищем значение в списке.
				$founded = array_search($value, $this->_values);
				if ($founded !== false)
				{
					// Если находим то устанавливаем его.
					$this->_value = $founded;
				}
				else
				{
					// Если нет, то сбрасываем текущее значение null.
					$this->_value = null;
				}
			}
		}

		/// <summary>
		/// Переопределенный. Метод возвращает строковое представление текущего значения перечисления.
		/// </summary>
		/// <returns>Строковое представление текущего значения перечисления.</returns>
		function __toString()
		{
			return $this->_value;
		}
	}
?>