<?php
	require_once('.php');

	/// <summary>
	/// Класс являющийся базовым для большинства других классов, реализует логику свойств и преобразования в строку.
	/// </summary>
	class Entity
	{
		/// <summary>
		/// Метод вызывается при попытке считать свойство объекта.
		/// Например: $name = $someObject->Name, вызовет метод __get с параметром $name равным "Name".
		/// </summary>
		/// <param name="name">Название свойства.</param>
		/// <returns>Значение свойства текущего объекта.</returns>
		function __get($name)
		{
			if (method_exists($this, 'get_' . $name))
			{
				eval('$result = $this->get_' . $name . '();');
			}
			else
			{
				$result = new ArgumentError('Произведено обращение к несуществующему свойству "' . $name . '"', 'name');
			}
			return $result;
		}

		/// <summary>
		/// Метод вызывается при попытке записать свойство объекта.
		/// Например: $someObject->Name = '123', вызовет метод __set с параметрами $name равным "Name" и $value равным "123".
		/// </summary>
		/// <param name="name">Название свойства.</param>
		/// <param name="value">Новое значение, которое должно установиться свойству.</param>
		function __set($name, $value)
		{
			eval('$this->set_' . $name . '($value);');
		}

		/// <summary>
		/// Переопределенный. Метод возвращает строковое представление состояния класса.
		/// </summary>
		/// <returns>Строковое представление состояния класса.</returns>
		function __toString()
		{
			$result = 'class: ' . get_class($this) . CRLF . 'members:' . CRLF . CRLF;
			$vars = get_object_vars($this);
			foreach ($vars as $varName => $var)
			{
				$result .= $varName . ': ' . $var;
			}
			return $result;
		}

		/// <summary>
		/// Достает данные из POST и присваивает полям элемента, если таковые найдутся
		/// </summary>
		function BindPOST($keys = null)
		{
			foreach($_POST as $key => $value)
			{
				if (!is_array($keys) || in_array($key, $keys))
				{
					if (property_exists($this, $key))
					{
						$value = refine_post($value);
						$ev = '$this->'.$key.' = $value;';
						eval($ev);
					}
				}
			}
		}

		/// <summary>
		/// Достает данные из POST и присваивает полям элемента, если таковые найдутся
		/// </summary>
		function BindGET($keys = null)
		{
			foreach($_GET as $key => $value)
			{
				if (!is_array($keys) || in_array($key, $keys))
				{
					if (property_exists($this, $key))
					{
						$ev = '$this->'.$key.' = $value;';
						eval($ev);
					}
				}
			}
		}

		/// <summary>
		/// Достает данные из массива и присваивает полям элемента
		/// </summary>
		function BindData($row, $keys = null)
		{
			foreach($row as $key => $value)
			{
				if (!is_array($keys) || in_array($key, $keys))
				{
					$ev = '$this->'.$key.' = $value;';
					eval($ev);
				}
			}
		}
	}
?>