<?php

require_once('system/UIHelpers.php');

/// <summary>
/// Элемент из БД
/// </summary>
class DALEntity extends Entity
{
	protected $_error;

	function get_Error()
	{
		return $this->_error;
	}

	/// <summary>
	/// Выполняет запрос и устанавливает ошибку
	/// </summary>
	protected function ExecuteQuery($q)
	{
		if ($res = mysqli_query($GLOBALS['link'], $q))
		{
			$this->_error = null;
			return $res;
    	}
		else
		{
			$this->_error = new Error('Ошибка MySQL: '.mysqli_error($GLOBALS['link']));
			return null;
		}
	}

	/// <summary>
	/// Выполняет хранимку и устанавливает ошибку
	/// </summary>
	protected function ExecuteSP($q)
	{
		if ($res = mysqli_query($GLOBALS['link'], $q))
		{
			while(mysqli_next_result($GLOBALS['link']))
				mysqli_store_result($GLOBALS['link']);

			$this->_error = null;
			return $res;
		}
		else
		{
			$this->_error = new Error('Ошибка MySQL: '.mysqli_error($GLOBALS['link']));
			return null;
		}
	}

	/// <summary>
	/// Выполняет хранимку, которая возвращает несколько результатов, и устанавливает ошибку
	/// </summary>
	protected function ExecuteSP_Multi($q)
	{
		$res = array();
		$res[] = mysqli_query($GLOBALS['link'], $q);
		if ($res[0])
		{
			while(mysqli_next_result($GLOBALS['link']))
				$res[] = mysqli_store_result($GLOBALS['link']);

			$this->_error = null;
			return $res;
		}
		else
		{
			$this->_error = new Error('Ошибка MySQL: '.mysqli_error($GLOBALS['link']));
			return null;
		}
	}

	/// <summary>
	/// Выполняет запрос и устанавливает ошибку. Возвращает значение первой строчки первого столбца
	/// </summary>
	protected function ExecuteScalarQuery($q)
	{
		if ($res = mysqli_query($GLOBALS['link'], $q))
		{
			if ($row = mysqli_fetch_array($res))
			{
				$this->_error = null;
				return $row[0];
			}
			else
			{
				$this->_error = new Error('Не удалось найти значение скалярного запроса');
				return null;
			}
		}
		else
		{
			$this->_error = new Error('Ошибка MySQL: '.mysqli_error($GLOBALS['link']));
			return null;
		}
	}

	protected function Begin()
	{
		if (!mysqli_query($GLOBALS['link'], 'BEGIN'))
			$this->_error = new Error('Ошибка MySQL: '.mysqli_error($GLOBALS['link']));
	}

	protected function Rollback()
	{
		if (!mysqli_rollback($GLOBALS['link']))
			$this->_error = new Error('Ошибка MySQL: '.mysqli_error($GLOBALS['link']));
	}

	protected function Commit()
	{
		if (!mysqli_commit($GLOBALS['link']))
			$this->_error = new Error('Ошибка MySQL: '.mysqli_error($GLOBALS['link']));
	}

	/// <summary>
	/// Возвращает запрос на апдейт, используя переданный массив с полями и их значениями.
	/// </summary>
	protected function GetUpdateQuery($update, $key, $additional_condition = null)
	{
		if ((is_array($update)) && (count($update) > 0))
		{
			$q = 'UPDATE '.$this->Table.' SET ';
			$first = 1;
			foreach($update as $field => $value)
			{
				if ($first)
				{
					$q .= $field.' = '.$value;
					$first = 0;
				}
				else
					$q .= ', '.$field.' = '.$value;
			}

			if (!is_null($key))
				$q .= ' WHERE '.$this->Key.' = '.$key;
			if ($additional_condition)
				$q .= " AND ($additional_condition)";
			$q .= ';';
			//echo "<pre>$q</pre>";
			return $q;
		}
		else
			return null;
	}
}

/// <summary>
/// Список элементов из БД
/// </summary>
class DALEntityList extends Entity
{
	protected $_items;
	protected $_error;
	protected $_q;
	protected $_qcount;
	protected $_key;
	protected $_entityname;

	protected $_itemsCount;

	public $PageSize;
	public $PageNumber;

	const DefaultPageSize = 20;

	function __construct($entityname, $q, $key)
	{
		$this->_entityname = $entityname;
		$this->_q = $q;
		$this->_qcount = null;
		$this->_key = $key;

		$this->PageSize = DALEntityList::DefaultPageSize;
		$this->PageNumber = 1;
	}

	function get_Items()
	{
		return $this->_items;
	}

	function get_ItemsCount()
	{
		return $this->_itemsCount;
	}

	function get_Error()
	{
		return $this->_error;
	}

	/// <summary>
	/// Выполняет запрос и устанавливает ошибку
	/// </summary>
	protected function ExecuteQuery($q)
	{
		if ($res = mysqli_query($GLOBALS['link'], $q))
		{
			$this->_error = null;
			return $res;
		}
		else
		{
			$this->_error = new Error('Ошибка MySQL: '.mysqli_error($GLOBALS['link']));
			return null;
		}
	}

	/// <summary>
	/// Выполняет запрос и устанавливает ошибку. Возвращает значение первой строчки первого столбца
	/// </summary>
	protected function ExecuteScalarQuery($q)
	{
		if ($res = mysqli_query($GLOBALS['link'], $q))
		{
			if ($row = mysqli_fetch_array($res))
			{
				$this->_error = null;
				return $row[0];
			}
			else
			{
				$this->_error = new Error('Не удалось найти значение скалярного запроса');
				return null;
			}
		}
		else
		{
			$this->_error = new Error('Ошибка MySQL: '.mysqli_error($GLOBALS['link']));
			return null;
		}
	}

	protected function Begin()
	{
		if (!mysqli_query($GLOBALS['link'], 'BEGIN'))
			$this->_error = new Error('Ошибка MySQL: '.mysqli_error($GLOBALS['link']));
	}

	protected function Rollback()
	{
		if (!mysqli_query($GLOBALS['link'], 'ROLLBACK'))
			$this->_error = new Error('Ошибка MySQL: '.mysqli_error($GLOBALS['link']));
	}

	protected function Commit()
	{
		if (!mysqli_query($GLOBALS['link'], 'COMMIT'))
			$this->_error = new Error('Ошибка MySQL: '.mysqli_error($GLOBALS['link']));
	}

	/// <summary>
	// Загружает массив элементов. Для загрузки всех элементов необходимо установить PageSize в 0 или null
	/// </summary>
	function Load()
	{
		$this->_items = null;

		// Пейджинг
		$this->PageSize = (integer)$this->PageSize;
		$this->PageNumber = (integer)$this->PageNumber;
		if ($this->PageNumber < 1)
			$this->PageNumber = 1;

		// Узнаем кол-во элементов, если соответствующий запрос задан. Нет смысла узнавать, если пейджинг отключен
		$this->_itemsCount = 0;
		if (($this->PageSize) && ($this->_qcount))
		{
			if ($res = mysqli_query($GLOBALS['link'], $this->_qcount))
		  	{
			  	if ($row = mysqli_fetch_array($res))
				  	$this->_itemsCount = (integer)$row[0];
		  	}
		  	else
		  	{
		  		$this->_error = new Error('Ошибка MySQL: '.mysqli_error($GLOBALS['link']));
		  		return;
	  		}
		}

		// Подготавливаем запрос
		$q = rtrim($this->_q, ';');
		if ($this->PageSize)
			$q .= "\r\nLIMIT ".(($this->PageNumber - 1) * $this->PageSize).', '.$this->PageSize;

		//echo "<pre>$q</pre>";
		// Делаем запрос к БД
		if ($res = mysqli_query($GLOBALS['link'], $q))
		{
			$this->_items = array();

			while($row = mysqli_fetch_assoc($res))
			{
				$ev = '$item = new '.$this->_entityname.'();';
				eval($ev);
				$item->BindData($row);
				$this->_items[$row[$this->_key]] = $item;
			}
			$this->_error = null;
		}
		else
			$this->_error = new Error('Ошибка MySQL: '.mysqli_error($GLOBALS['link']));
	}
}

?>