<?php
	require_once('.php');

	/// <summary>
	/// Статический класс содержащий вспомогательные методы.
	/// </summary>
	class Helper
	{
		/// <summary>
		/// Обрабатывает значение и возвращает null или числовое значение.
		/// </summary>
		/// <param name="value">Значение которое необходимо обработать.</param>
		/// <returns>Null или числовое значение</returns>
		static function NullOrInteger($value)
		{
			if (is_null($value))
			{
				return 'NULL';
			}
			else
			{
				return intval($value);
			}
		}

		/// <summary>
		/// Проверяет наличия значения в переменной value, в случае его отстутсвия возвращает строку по умолчанию.
		/// </summary>
		/// <param name="value">Переменная значение которой необходимо проверить.</param>
		/// <param name="default">Значение по умолчанию.</param>
		/// <returns>Значение переменной value, или default в случае его отстутсвия.</returns>
		static function StringOrDefault($value, $default ='')
		{
			if (is_null($value))
			{
				return $default;
			}
			else
			{
				return $value;
			}
		}

		/// <summary>
		/// Возвращает первый день в текущем году
		/// </summary>
		static function GetFirstYearDay()
		{
			return date('Y-01-01');
		}

		/// <summary>
		/// Возвращает текущую дату
		/// </summary>
		static function GetCurrentDate()
		{
			return date('Y-m-d');
		}
	}
?>