﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Drawing2D;

using CarApplet;

namespace DashBoard
{
    public class DashApplet : Applet
    {

        public TachoForm form;
        static public FuelForm formF;
        static public RPMForm formR;
        public static Sensor snsRPM;
        public static Sensor snsSpeed;
        public static Sensor snsFuel;
        public static Sensor snsCoolant;
        //
        public static Sensor snsMAF;
        public static Sensor snsMAP;
        public static Sensor snsBarometricPres;
        public static Sensor snsIgnitionTiming;
        public static Sensor snsInjTime;
        public static Sensor snsIntakeTemp;
        public static Sensor snsThrottlePos;
        public static Sensor snsVoltage;

        //
        public static Sensor snsAvgFuelPerDist;
        public static Sensor snsAvgFuelPerHour;
        public static Sensor snsFuelConsumed;
        public static Sensor snsLosingDistance;
        public static Sensor snsFuelPerDist;
        public static Sensor snsFuelPerHour;
        public static Sensor snsLostSeconds;
        public static Sensor snsLostFuel;
        int k;
   
        public Form Init(CarGateway gw)
        {
            // Вытаскиваем датчик оборотов и сообщаем системе, что он нам нужен
            snsRPM = gw.AllSensors["CheckEngine.Params.EngineSpeed"];
            snsSpeed = gw.AllSensors["CheckEngine.Params.Speed"];
            snsMAF = gw.AllSensors["CheckEngine.Params.MAF"];
            snsMAP = gw.AllSensors["CheckEngine.Params.MAP"];
            snsFuel = gw.AllSensors["CheckEngine.Params.FuelLevel"];
            snsCoolant = gw.AllSensors["CheckEngine.Params.CoolantTemp"];
            snsAvgFuelPerDist = gw.AllSensors["CheckEngine.TheTrip.AvgFuelPerDist"];
            snsAvgFuelPerHour = gw.AllSensors["CheckEngine.TheTrip.AvgFuelPerHour"];
            snsFuelConsumed = gw.AllSensors["CheckEngine.TheTrip.FuelConsumed"];
            snsLosingDistance = gw.AllSensors["CheckEngine.TheTrip.LosingDistance"];
            snsFuelPerDist = gw.AllSensors["CheckEngine.TheTrip.FuelPerDist"];
            snsFuelPerHour = gw.AllSensors["CheckEngine.TheTrip.FuelPerHour"];
            snsLostSeconds = gw.AllSensors["CheckEngine.TheTrip.LostSeconds"];
            snsLostFuel = gw.AllSensors["CheckEngine.TheTrip.LostFuel"];
            snsBarometricPres = gw.AllSensors["CheckEngine.Params.BarometricPres"];
            snsIgnitionTiming = gw.AllSensors["CheckEngine.Params.IgnitionTiming"];
            snsInjTime = gw.AllSensors["CheckEngine.Params.InjTime"];
            snsIntakeTemp = gw.AllSensors["CheckEngine.Params.IntakeTemp"];
            snsThrottlePos = gw.AllSensors["CheckEngine.Params.ThrottlePos"];
            snsVoltage = gw.AllSensors["CheckEngine.Params.Voltage"];


            snsRPM.Essential = true;
            snsSpeed.Essential = true;
            snsMAP.Essential = true;
            snsFuel.Essential = true;
            snsCoolant.Essential = true;
            //snsMAF.Essential = true;
            //snsAvgFuelPerDist.Essential = true;
            //snsAvgFuelPerHour.Essential = true;
            //snsFuelConsumed.Essential = true;
            //snsLosingDistance.Essential = true;
            //snsFuelPerDist.Essential = true;
            //snsFuelPerHour.Essential = true;
            //snsLostSeconds.Essential = true;
            //snsLostFuel.Essential = true;
            //snsBarometricPres.Essential = true;
            //snsIgnitionTiming.Essential = true;
            //snsInjTime.Essential = true;
            //snsIntakeTemp.Essential = true;
            //snsThrottlePos.Essential = true;
            //snsVoltage.Essential = true;




            // Создаем окошко тахометра и возвращаем его
            form = new TachoForm();
            formF = new FuelForm();
            formR = new RPMForm();

            //formF.Show();
            form.formF = formF;
            form.formR = formR;
            formF.form = form;
            formR.form = form;
            return form;
        }
        static public void ActivateFuelSensors()
        {
            snsRPM.Essential = false;
            snsSpeed.Essential = false;
            snsMAP.Essential = false;
            snsFuel.Essential = false;
            snsCoolant.Essential = false;
            snsAvgFuelPerDist.Essential = true;
            snsAvgFuelPerHour.Essential = true;
            snsFuelConsumed.Essential = true;
            snsLosingDistance.Essential = true;
            snsFuelPerDist.Essential = true;
            snsFuelPerHour.Essential = true;
            snsLostSeconds.Essential = true;
            snsLostFuel.Essential = true;
        }
        static public void DeactivateFuelSensors()
        {
            snsRPM.Essential = true;
            snsSpeed.Essential = true;
            snsMAP.Essential = true;
            snsFuel.Essential = true;
            snsCoolant.Essential = true;
            snsAvgFuelPerDist.Essential = false;
            snsAvgFuelPerHour.Essential = false;
            snsFuelConsumed.Essential = false;
            snsLosingDistance.Essential = false;
            snsFuelPerDist.Essential = false;
            snsFuelPerHour.Essential = false;
            snsLostSeconds.Essential = false;
            snsLostFuel.Essential = false;
        }
        static public void ActivateRPMSensors()
        {
            snsRPM.Essential = false;
            snsSpeed.Essential = false;
            snsMAP.Essential = false;
            snsFuel.Essential = false;
            snsCoolant.Essential = false;
            snsMAF.Essential = true;
            snsBarometricPres.Essential = true;
            snsIgnitionTiming.Essential = true;
            snsInjTime.Essential = true;
            snsIntakeTemp.Essential = true;
            snsThrottlePos.Essential = true;
            snsVoltage.Essential = true;
        }
        static public void DeactivateRPMSensors()
        {
            snsRPM.Essential = true;
            snsSpeed.Essential = true;
            snsMAP.Essential = true;
            snsFuel.Essential = true;
            snsCoolant.Essential = true;
            snsMAF.Essential = false;
            snsBarometricPres.Essential = false;
            snsIgnitionTiming.Essential = false;
            snsInjTime.Essential = false;
            snsIntakeTemp.Essential = false;
            snsThrottlePos.Essential = false;
            snsVoltage.Essential = false;
        }
        private Point RadialPoint(int radius, int seconds, Point ptCenter)
        {
            //Point ptCenter = new Point(110,110);
            double angle = -((seconds + 90) % 360) * Math.PI / 180;
            Point ret = new Point(
                ptCenter.X + (int)(radius * Math.Cos(angle)),
                ptCenter.Y - (int)(radius * Math.Sin(angle)));
            return ret;
        }
        public void UpdateDisplay()
        {
            //System.Diagnostics.Stopwatch myStopwatch = new System.Diagnostics.Stopwatch();
            //myStopwatch.Start(); //запуск

            int ugol;
            Point ptCenter;
            int radius;
            System.Drawing.Graphics graphicsObj;
            
            //************
            //Тахометр 
            //************
            // Если значение датчика еще не определено - ничего делать не нужно
            if ((!snsRPM.Undefined)&(form.labelRPM.Text != snsRPM.Textual))
            {
                graphicsObj = form.TachopictureBox.CreateGraphics();
                graphicsObj.SmoothingMode = SmoothingMode.HighQuality;
                ptCenter = new Point(150, 150);
                radius = 150;
                //стрелка
                graphicsObj.ResetClip();
                ugol = (int)(snsRPM.Numeric * 0.03);
                form.TachopictureBox.Refresh();
                using (Pen pen = new Pen(Color.Red, 4))
                {
                    pen.CustomEndCap = new AdjustableArrowCap(4, 6, true);
                    graphicsObj.DrawLine(pen, RadialPoint(20, ugol + 180, ptCenter), RadialPoint(radius - 20, ugol, ptCenter));
                }
                using (SolidBrush br = new SolidBrush(Color.FromArgb(100, Color.Wheat)))
                    graphicsObj.FillEllipse(br, ptCenter.X - 5, ptCenter.Y - 5, 10, 10);
                graphicsObj.Dispose();
            }
            //****************
            //рисуем спидометр
            //****************
            if ((!snsSpeed.Undefined)&(form.labelSpeed.Text != snsSpeed.Textual))
            {
                graphicsObj = form.SpeedpictureBox.CreateGraphics();
                graphicsObj.SmoothingMode = SmoothingMode.HighQuality;
                ptCenter = new Point(150, 150);
                radius = 150;
                form.SpeedpictureBox.Refresh();
                ugol = (int)(snsSpeed.Numeric * 1.35 + 45);
                using (Pen pen = new Pen(Color.Red, 4))
                {
                    pen.CustomEndCap = new AdjustableArrowCap(4, 6, true);
                    graphicsObj.DrawLine(pen, RadialPoint(20, ugol + 180, ptCenter), RadialPoint(radius - 20, ugol, ptCenter));
                }
                using (SolidBrush br = new SolidBrush(Color.FromArgb(100, Color.Wheat)))
                    graphicsObj.FillEllipse(br, ptCenter.X - 5, ptCenter.Y - 5, 10, 10);
                graphicsObj.Dispose();
            }
            //****************
            //уровень топлива 
            //****************
            if ((!snsFuel.Undefined)&(form.labelfuel.Text != Convert.ToString(snsFuel.Numeric * 0.6)))
            {
                graphicsObj = form.FuelpictureBox.CreateGraphics();
                ptCenter = new Point(100, 100);
                radius = 100;
                graphicsObj.SmoothingMode = SmoothingMode.HighQuality;
                form.FuelpictureBox.Refresh();

                ugol = (int)(snsFuel.Numeric * 1.8 + 90);
                using (Pen pen = new Pen(Color.Red, 4))
                {
                    pen.CustomEndCap = new AdjustableArrowCap(4, 6, true);
                    graphicsObj.DrawLine(pen, RadialPoint(20, ugol + 180, ptCenter), RadialPoint(radius - 20, ugol, ptCenter));
                }
                using (SolidBrush br = new SolidBrush(Color.FromArgb(100, Color.Wheat)))
                    graphicsObj.FillEllipse(br, ptCenter.X - 5, ptCenter.Y - 5, 10, 10);
                graphicsObj.Dispose();
            }
            //**************
            //температура 
            //**************
            if ((!snsCoolant.Undefined)&(form.labelTemp.Text != snsCoolant.Textual))
            {
                graphicsObj = form.CoolantpictureBox.CreateGraphics();
                ptCenter = new Point(100, 100);
                radius = 100;
                graphicsObj.SmoothingMode = SmoothingMode.HighQuality;
                form.CoolantpictureBox.Refresh();
                ugol = (int)snsCoolant.Numeric * 2;
                if (ugol < 90) ugol = 90;
                using (Pen pen = new Pen(Color.Red, 4))
                {
                    pen.CustomEndCap = new AdjustableArrowCap(4, 6, true);
                    graphicsObj.DrawLine(pen, RadialPoint(20, ugol + 180, ptCenter), RadialPoint(radius - 20, ugol, ptCenter));
                }
                using (SolidBrush br = new SolidBrush(Color.FromArgb(100, Color.Wheat)))
                    graphicsObj.FillEllipse(br, ptCenter.X - 5, ptCenter.Y - 5, 10, 10);
                graphicsObj.Dispose();
            }
            //*********
            // Boost 
            //*********
            if ((!snsMAP.Undefined)&(form.labelBoost.Text != Convert.ToString(snsMAP.Numeric - 1)))
            {
                graphicsObj = form.BoostpictureBox.CreateGraphics();

                ptCenter = new Point(100, 100);
                radius = 100;
                graphicsObj.SmoothingMode = SmoothingMode.HighQuality;
                form.BoostpictureBox.Refresh();

                ugol = (int)(snsMAP.Numeric * 90);

                using (Pen pen = new Pen(Color.Red, 4))
                {
                    pen.CustomEndCap = new AdjustableArrowCap(4, 6, true);
                    graphicsObj.DrawLine(pen, RadialPoint(20, ugol + 180, ptCenter), RadialPoint(radius - 20, ugol, ptCenter));
                }
                using (SolidBrush br = new SolidBrush(Color.FromArgb(100, Color.Wheat)))
                    graphicsObj.FillEllipse(br, ptCenter.X - 5, ptCenter.Y - 5, 10, 10);
                graphicsObj.Dispose();
            }
            
            // Обновляем текстовые значения 

            //Главная форма
            if (form.labelRPM.Text != snsRPM.Textual) form.labelRPM.Text = snsRPM.Textual;
            if (form.labelSpeed.Text != snsSpeed.Textual) form.labelSpeed.Text = snsSpeed.Textual;
            if (form.labelfuel.Text != Convert.ToString(snsFuel.Numeric * 0.6)) form.labelfuel.Text = Convert.ToString(snsFuel.Numeric * 0.6);
            if (form.labelTemp.Text != snsCoolant.Textual) form.labelTemp.Text = snsCoolant.Textual;
            if (form.labelBoost.Text != Convert.ToString(snsMAP.Numeric - 1)) form.labelBoost.Text = Convert.ToString(snsMAP.Numeric - 1);
            
            //топливо
            if (formF.labelAvgFuelPerDist.Text != snsAvgFuelPerDist.Textual) formF.labelAvgFuelPerDist.Text = snsAvgFuelPerDist.Textual;
            if (formF.labelAvgFuelPerHour.Text != snsAvgFuelPerHour.Textual) formF.labelAvgFuelPerHour.Text = snsAvgFuelPerHour.Textual;
            if (formF.labelFuelConsumed.Text != snsFuelConsumed.Textual) formF.labelFuelConsumed.Text = snsFuelConsumed.Textual;
            if (formF.labelLosingDistance.Text != snsLosingDistance.Textual) formF.labelLosingDistance.Text = snsLosingDistance.Textual;
            if (formF.labelFuelPerDist.Text != snsFuelPerDist.Textual) formF.labelFuelPerDist.Text = snsFuelPerDist.Textual;
            if (formF.labelFuelPerHour.Text != snsFuelPerHour.Textual) formF.labelFuelPerHour.Text = snsFuelPerHour.Textual;
            if (formF.labelLostSeconds.Text != snsLostSeconds.Textual) formF.labelLostSeconds.Text = snsLostSeconds.Textual;
            if (formF.labelLostFuel.Text != snsLostFuel.Textual) formF.labelLostFuel.Text = snsLostFuel.Textual;

            //двигатель
            if (formR.labelMAF.Text != snsMAF.Textual) formR.labelMAF.Text = snsMAF.Textual;
            if (formR.labelMAP.Text != snsMAP.Textual) formR.labelMAP.Text = snsMAP.Textual;
            if (formR.labelInjTime.Text != snsInjTime.Textual) formR.labelInjTime.Text = snsInjTime.Textual;
            if (formR.labelBarometricPres.Text != snsBarometricPres.Textual) formR.labelBarometricPres.Text = snsBarometricPres.Textual;
            if (formR.labelIgnitionTiming.Text != snsIgnitionTiming.Textual) formR.labelIgnitionTiming.Text = snsIgnitionTiming.Textual;
            if (formR.labelIntakeTemp.Text != snsIntakeTemp.Textual) formR.labelIntakeTemp.Text = snsIntakeTemp.Textual;
            if (formR.labelThrottlePos.Text != snsThrottlePos.Textual) formR.labelThrottlePos.Text = snsThrottlePos.Textual;
            
            //myStopwatch.Stop();
            //TimeSpan ts = myStopwatch.Elapsed;

            // Format and display the TimeSpan value.
            //string elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}",
            //    ts.Hours, ts.Minutes, ts.Seconds,
            //    ts.Milliseconds / 10);
            //k = k + 1;
            //form.labelTime.Text = k+"  "+elapsedTime + "  "+ snsRPM.Updated.Seconds + " "+ snsRPM.Updated.Time  ;
            //MessageBox.Show(elapsedTime);


        }
    }
}


