Attribute VB_Name = "ModTMS"
Option Explicit

Enum pressure
    KPa = 0
    Bar = 1
    PSI = 2
End Enum

Enum temperature
    C = 0
    F = 1
End Enum

Enum SensorState
    StorageMode = 0
    NormalMode = 1
    PressureAlertMode = 2
    TemperatureAlertMode = 3
End Enum

Type TiresData
    Sensor As Integer
    pressure As Byte
    temperature As Byte
    Battery As Byte
    Status As SensorState
    MinPressure As Byte
    MaxPressure As Byte
    MaxTemperature As Byte
    MinPressureMessage As String
    MaxPressureMessage As String
    MaxTemperatureMessage As String
    Alert As Boolean
End Type

Dim PressureUnit As pressure
Dim TemperatureUnit As temperature
Dim PressureSuffix As String
Dim TemperatureSuffix As String




Dim SDK As Object

Public SkinPath As String
Public Tire(5) As TiresData
Public SilentMode As Boolean
Public PressureAlert As Boolean
Public TemperatureAlert As Boolean

'  
Private Declare Function SetWindowPos Lib "user32" _
    (ByVal hwnd As Long, _
     ByVal hWndInsertAfter As Long, _
     ByVal X As Long, _
     ByVal Y As Long, _
     ByVal cx As Long, _
     ByVal cy As Long, _
     ByVal wFlags As Long) As Long
Private Const HWND_NOTOPMOST = -2
Private Const HWND_TOPMOST = -1
Private Const SWP_NOACTIVATE = &H10
Private Const SWP_NOMOVE = &H2
Private Const SWP_NOSIZE = &H1

Private Sub SetFormPosition(frmHandl As Long, TopPosition As Boolean)
If TopPosition Then
    SetWindowPos frmHandl, HWND_TOPMOST, 0, 0, 0, 0, _
    SWP_NOACTIVATE Or SWP_NOSIZE Or SWP_NOMOVE
Else
    SetWindowPos frmHandl, HWND_NOTOPMOST, 0, 0, 0, 0, _
    SWP_NOSIZE Or SWP_NOMOVE
End If
End Sub


Public Sub Startup()
'Actions that must execute when the program starts.
    
Dim n As Integer
    
    'Set default values
    For n = 1 To 5
        With Tire(n)
            .pressure = &HFF
            .temperature = &HFF
            .Battery = 0
            .Status = 0
            .Alert = False
        End With
    Next n
            
    Call LoadSettings
    
    'Create COM interface to RoadRunner SDK
    'Set SDK = CreateObject("RoadRunner.SDK")
    
    'SkinPath = SDK.GetInfo("RRSKIN")
    'MsgBox ("OK")
    
    FrmTimer.TmrEvents.Enabled = True
    FrmTimer.TmrEvents.Interval = 10000
    
    tpms.TimerWarning.Enabled = False
    tpms.TimerWarning.Interval = 500

End Sub

Public Sub Shutdown()
'Actions that must execute when the program ends.

    'Close the open handles to the device.
    Call HidShutdown

End Sub

Private Sub LoadSettings()

Dim iniFile As New ClsIniFile
Dim n As Integer

    'Read config from .ini file
    iniFile.FileName = App.Path & "/RRTMS.ini"
        
    iniFile.ApplicationKey = "SENSORS LOCATION"
    'Sensor location
    For n = 1 To 5
        Tire(n).Sensor = Val(iniFile.GetValue("Tire" & CStr(n), n))
    Next n
    
    iniFile.ApplicationKey = "MIN PRESSURE ALERT"
    'Minimum pressure alert
    For n = 1 To 5
        Tire(n).MinPressure = Val(iniFile.GetValue("Tire" & CStr(n), 108))
    Next n

    iniFile.ApplicationKey = "MAX PRESSURE ALERT"
    'Maximum pressure alert
    For n = 1 To 5
        Tire(n).MaxPressure = Val(iniFile.GetValue("Tire" & CStr(n), 160))
    Next n

    iniFile.ApplicationKey = "MAX TEMPERATURE ALERT"
    'Maximum temperature alert
    For n = 1 To 5
        Tire(n).MaxTemperature = Val(iniFile.GetValue("Tire" & CStr(n), 120))
    Next n
        
    iniFile.ApplicationKey = "MIN PRESSURE MESSAGE"
    'Minimum pressure alert message
    For n = 1 To 5
        Tire(n).MinPressureMessage = iniFile.GetValue("Tire" & CStr(n), "")
    Next n

    iniFile.ApplicationKey = "MAX PRESSURE MESSAGE"
    'Maximum pressure alert message
    For n = 1 To 5
        Tire(n).MaxPressureMessage = iniFile.GetValue("Tire" & CStr(n), "")
    Next n

    iniFile.ApplicationKey = "MAX TEMPERATURE MESSAGE"
    'Maximum temperature alert message
    For n = 1 To 5
        Tire(n).MaxTemperatureMessage = iniFile.GetValue("Tire" & CStr(n), "")
    Next n
                
    iniFile.ApplicationKey = "UNITS OF MEASUREMENT"
    'Pressure unit
    PressureUnit = Val(iniFile.GetValue("Pressure", "0"))
    Select Case PressureUnit
        Case KPa
            PressureSuffix = "KPa"
        Case Bar
            PressureSuffix = "Bar"
        Case PSI
            PressureSuffix = "PSI"
    End Select
    'Temperature unit
    TemperatureUnit = Val(iniFile.GetValue("Temperature", "0"))
    Select Case TemperatureUnit
        Case C
            TemperatureSuffix = "C"
        Case F
            TemperatureSuffix = "F"
    End Select
        
End Sub

Public Function PressureToString(pressure As Byte) As String
            
    If pressure = &HFF Then
        PressureToString = "--- " & PressureSuffix
    Else
        Select Case PressureUnit
            Case KPa
                PressureToString = Format(pressure * 2.5 - 100, "##0") & PressureSuffix
            Case Bar
                PressureToString = Format((pressure * 2.5 - 100) / 100, "0.00") & PressureSuffix
            Case PSI
                PressureToString = Format((pressure * 2.5 - 100) * 0.145, "#0.0") & PressureSuffix
        End Select
    End If

End Function

Public Function TemperatureToString(temperature As Byte) As String
            
    If temperature = &HFF Then
        TemperatureToString = "--" & TemperatureSuffix
    Else
        Select Case TemperatureUnit
            Case C
                TemperatureToString = Format(temperature - 40, "##0") & TemperatureSuffix
            Case F
                TemperatureToString = Format((temperature - 40) * 9 / 5 + 32, "##0") & TemperatureSuffix
        End Select
    End If

End Function

Public Sub GetDataFromDevice()
'Sends one byte to the device and reads four bytes back.

Dim n As Long

    'Reset alerts
    PressureAlert = False
    TemperatureAlert = False

    'If the device hasn't been detected or it timed out on a previous attempt
    'to access it, look for the device.
    If HidDeviceDetected = False Then HidDeviceDetected = FindTheHid
    
    'The device has been detected
    If HidDeviceDetected = True Then
        For n = 1 To 5
            If Tire(n).Sensor > 0 Then
                'Load the buffer with the byte to be sent.
                HidOutputReportData(0) = &H20 + Tire(n).Sensor
                'Write the data to the device
                Call HidWriteReport
                'Read the data from the device.
                Call HidReadReport
                'Error prevention
                If HidDeviceDetected = False Or HidInputReportData(1) < 38 Then Exit For
                'Get pressure
                Tire(n).pressure = HidInputReportData(1)
                'Get temperature
                Tire(n).temperature = HidInputReportData(2)
               'Get battery
                If HidInputReportData(3) = &HFF Then
                    Tire(n).Battery = 0
                Else
                    Tire(n).Battery = HidInputReportData(3) And 127
                End If
                'Get the sensor status
                If HidInputReportData(4) = &HFF Then
                    Tire(n).Status = 0
                Else
                    Tire(n).Status = HidInputReportData(4)
                End If
                Call Update_text(PressureToString(Tire(n).pressure), TemperatureToString(Tire(n).temperature), n * 1)
                Call Update_Picture(Tire(n).Battery, n * 1)
                
            End If
        Next n
    End If
   
   'The device hasn't been detected or has been lost.
    If HidDeviceDetected = False Then
        For n = 1 To 5
            If Tire(n).Sensor > 0 Then
                With Tire(n)
                    .pressure = &HFF
                    .temperature = &HFF
                    .Battery = 0
                    .Status = 0
                    .Alert = False
                End With
            End If
        Next n
    End If

    'Alerts handle
    For n = 1 To 5
        With Tire(n)
            If .pressure < &HFF And .pressure < .MinPressure Then
                PressureAlert = True
                If Not .Alert And Not SilentMode Then
                    'If SDK.GetInfo("RRSCREEN") <> "tms.skin" Then SDK.Execute "TMS"
                    'If .MinPressureMessage <> "" Then SDK.Execute "SAY;" & .MinPressureMessage
                    .Alert = True
                    Alert_Picture (1)
                End If
            ElseIf .pressure < &HFF And .pressure > .MaxPressure Then
                PressureAlert = True
                If Not .Alert And Not SilentMode Then
                    'If SDK.GetInfo("RRSCREEN") <> "tms.skin" Then SDK.Execute "TMS"
                    'If .MaxPressureMessage <> "" Then SDK.Execute "SAY;" & .MaxPressureMessage
                    .Alert = True
                    Alert_Picture (1)
                End If
            ElseIf .temperature < &HFF And .temperature > .MaxTemperature Then
                TemperatureAlert = True
                If Not .Alert And Not SilentMode Then
                    'If SDK.GetInfo("RRSCREEN") <> "tms.skin" Then SDK.Execute "TMS"
                    'If .MaxTemperatureMessage <> "" Then SDK.Execute "SAY;" & .MaxTemperatureMessage
                    Tire(n).Alert = True
                    Alert_Picture (2)
                End If
            Else
                .Alert = False
            End If
        End With
    Next n
    
    For n = 1 To 5
        With Tire(n)
            If .Alert = True Then
                tpms.TimerWarning.Enabled = True
                'tpms.ZOrder (0)
                Call SetFormPosition(tpms.hwnd, True)
                Call SetFormPosition(tpms.hwnd, False)
                Exit For
            End If
            tpms.TimerWarning.Enabled = False
        End With
    Next n
            
        
   
   
End Sub

Public Sub Update_text(pressure, temperature As String, n As Integer)
    Select Case n
        Case 1
            tpms.Tire1_pressure.Caption = pressure
            tpms.Tire1_temperature.Caption = temperature
        Case 2
            tpms.Tire2_pressure.Caption = pressure
            tpms.Tire2_temperature.Caption = temperature
        Case 3
            tpms.Tire3_pressure.Caption = pressure
            tpms.Tire3_temperature.Caption = temperature
        Case 4
            tpms.Tire4_pressure.Caption = pressure
            tpms.Tire4_temperature.Caption = temperature
    End Select
End Sub

Public Sub Update_Picture(percent, n As Integer)
    Select Case n
        Case 1
            tpms.Battery1.Picture = LoadPicture(App.Path & "/SLIDER_BATTERY/SLIDER_" & Int(percent / 5) & ".gif")
            tpms.Battery1_percent.Caption = percent
        Case 2
            tpms.Battery2.Picture = LoadPicture(App.Path & "/SLIDER_BATTERY/SLIDER_" & Int(percent / 5) & ".gif")
            tpms.Battery2_percent.Caption = percent
        Case 3
            tpms.Battery3.Picture = LoadPicture(App.Path & "/SLIDER_BATTERY/SLIDER_" & Int(percent / 5) & ".gif")
            tpms.Battery3_percent.Caption = percent
        Case 4
            tpms.Battery4.Picture = LoadPicture(App.Path & "/SLIDER_BATTERY/SLIDER_" & Int(percent / 5) & ".gif")
            tpms.Battery4_percent.Caption = percent
    End Select
        
End Sub

Public Sub Alert_Picture(Optional n As Integer)
'1-  2-
    Select Case n
        Case 1
            tpms.ImageWarning.Picture = LoadPicture(App.Path & "/warnings/pressure_warning.gif")
        Case 2
            tpms.ImageWarning.Picture = LoadPicture(App.Path & "/warnings/temperature_warning.gif")
    End Select
    If tpms.ImageWarning.Visible = True Then
        tpms.ImageWarning.Visible = False
    Else
        tpms.ImageWarning.Visible = True
    End If
    
    
End Sub

