VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "RRExtension"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'*****************************************************************
'* This is an interface to add commands/labels/indicators/sliders
'* to RoadRunner without needing a whole new application for such.
'*
'* You can monitor commands executed in RR by checking the CMD
'* paramter of ProcessCommand and similarly monitor labels and
'* indicators of the current screen. The idea is so you can create
'* new commands, labels, indicators and sliders without having
'* to re-compile or understand the code in RoadRunner.
'*
'* Furthermore, it should be possible to intercept commands and
'* modify them to your interst, say "AUDIO" to "LOAD;MYAUDIO.SKIN"
'* for this all you need to do is modify CMD and return 3 on the
'* processcommand call so that RR executes the command you return.
'*
'* You can also use ComSend "RoadRunner","COMMAND" to execute any
'* standard RR command from here. Keep in mind that any commands
'* executed in that fashion will NOT execute until your current
'* command is done processing.
'*
'* NOTE >> COMSEND ONLY WORKS WITH THE COMPILED VERSION OF RR <<
'*
'* NOTE 2 >> You should consider removing ModCom from this project
'* and using the COM interface instead of COMSEND. It Offers more
'* features with less code. To know more about this, please check
'* RR's help file or mp3car.com for documentation.
'*
'* You're free to use this code in any way you see fit.
'*
'*****************************************************************

'*****************************************************************
'* This Function will be called with the current command string
'* The return parameter of this function determines the handling
'* To be taken upon returning to RR:
'*
'* 0 = Command not processed here
'* 1 = Command completed + return to previous screen
'* 2 = Command completed, stay on current screen
'* 3 = Command has been changed/modified, execute returned one
'*
'* frm is the form object which generated the current command. Be
'* VERY VERY careful when using it.
'*
'* frm.tag contains the screen name for the same screen.
'* you can poll other propperties/methods from the screen but you
'* will need to look at RR's frmskin to know what you can use/do.
'*****************************************************************
Public Function ProcessCommand(CMD As String, frm As Object) As Integer

    Select Case LCase(CMD)
        
        Case "tms"
            CMD = "LOAD;TMS.skin"
            ProcessCommand = 3
        
        
        Case "tms_silent"
            SilentMode = Not SilentMode
            ProcessCommand = 2
    
    End Select

End Function

'*****************************************************************
'* This Function will be called with a requested label code and
'* format specified at the skin file. Simply return any text to
'* be displayed for the specified format.
'*****************************************************************
Public Function ReturnLabel(LBL As String, FMT As String) As String

    Select Case LCase(LBL)
        
        Case "tms_pressure_fl" 'Front left tire pressure
            ReturnLabel = PressureToString(Tire(1).pressure)
        
        Case "tms_pressure_fr" 'Front right tire pressure
            ReturnLabel = PressureToString(Tire(2).pressure)
                        
        Case "tms_pressure_rr" 'Rear right tire pressure
            ReturnLabel = PressureToString(Tire(3).pressure)
            
        Case "tms_pressure_rl" 'Rear left tire pressure
            ReturnLabel = PressureToString(Tire(4).pressure)
            
        Case "tms_pressure_st" 'Spare tire pressure
            ReturnLabel = PressureToString(Tire(5).pressure)
            
        Case "tms_temperature_fl" 'Front left tire temperature
            ReturnLabel = TemperatureToString(Tire(1).temperature)
                
        Case "tms_temperature_fr" 'Front right tire temperature
            ReturnLabel = TemperatureToString(Tire(2).temperature)
                                
        Case "tms_temperature_rr" 'Rear right tire temperature
            ReturnLabel = TemperatureToString(Tire(3).temperature)
                
        Case "tms_temperature_rl" 'Rear left tire temperature
            ReturnLabel = TemperatureToString(Tire(4).temperature)
                                
        Case "tms_temperature_st" 'Spare tire temperature
            ReturnLabel = TemperatureToString(Tire(5).temperature)
                
    End Select

End Function

'*****************************************************************
'* This Function will be called with requested indicator code
'* specified at the skin file. Simply return "True" or "False" to
'* displayed the respective ON or OFF layer of the skin images.
'* alternatively you can specify a path to a file to be displayed
'* as the indicator specified. Return "False" to erase the image.
'*****************************************************************
Public Function ReturnIndicatorEx(IND As String) As String

    'Default (No Action)
    'DO NOT RETURN "False" for unprocess indicators, return ""
    ReturnIndicatorEx = ""
    
    Select Case LCase(IND)
    
        Case "tms_silent"
            ReturnIndicatorEx = IIf(SilentMode, "True", "False")
    
        Case "tms_alert_fl"
            ReturnIndicatorEx = IIf(Tire(1).Alert, "True", "False")
        
        Case "tms_alert_fr"
            ReturnIndicatorEx = IIf(Tire(2).Alert, "True", "False")
                        
        Case "tms_alert_rr"
            ReturnIndicatorEx = IIf(Tire(3).Alert, "True", "False")
            
        Case "tms_alert_rl"
            ReturnIndicatorEx = IIf(Tire(4).Alert, "True", "False")
            
        Case "tms_alert_st"
            ReturnIndicatorEx = IIf(Tire(5).Alert, "True", "False")
            
        Case "tms_pressure_alert"
            ReturnIndicatorEx = IIf(PressureAlert, "True", "False")
        
        Case "tms_temperature_alert"
            ReturnIndicatorEx = IIf(TemperatureAlert, "True", "False")
            
        Case "tms_alert"
            If PressureAlert Then
                ReturnIndicatorEx = SkinPath & "tms_pressure.gif"
            ElseIf TemperatureAlert Then
                ReturnIndicatorEx = SkinPath & "tms_temperature.gif"
            Else
                ReturnIndicatorEx = "False"
            End If

    End Select

End Function

'*****************************************************************
'* This Sub will be called with an indicator code "CLICKED"
'* specified at the skin file. This "event" so to speak can be used
'* to toggle indicators or execute any code you desire when clicking
'* on a specifig indicator in the skin. You can also modify IND and
'* monitor the IND parameter as to detect/alter the behaviour of
'* how RR will process the indicator code being clicked.
'*****************************************************************
Public Sub IndicatorClick(IND As String)

End Sub

'*****************************************************************
'* This Function will be called with requested slider code
'* specified at the skin file. Simply return the value of the
'* slider to be displayed. Values should range from 0 to 65536.
'* It is also possible to intercept/change the slider code before
'* it is processed in RoadRunner (to overwrite existing codes).
'*****************************************************************
Public Function ReturnSlider(SLD As String) As Long

    'This tells RR that the Slider was not processed in this plugin
    ReturnSlider = -1

    Select Case LCase(SLD)
        Case "tms_battery_fl" 'Front left tire battery level
            ReturnSlider = Int(655.36 * Tire(1).Battery)

        Case "tms_battery_fr" 'Front right tire battery level
            ReturnSlider = Int(655.36 * Tire(2).Battery)

        Case "tms_battery_rr" 'Rear right tire battery level
            ReturnSlider = Int(655.36 * Tire(3).Battery)
        
        Case "tms_battery_rl" 'Rear left tire battery level
            ReturnSlider = Int(655.36 * Tire(4).Battery)

        Case "tms_battery_st" 'Spare tire battery level
            ReturnSlider = Int(655.36 * Tire(5).Battery)
    End Select
    
End Function

'*****************************************************************
'* This Function will be called with requested slider code
'* specified at the skin file. Simply return the value of the
'* slider to be displayed. Values should range from 0 to 65536.
'* It is also possible to intercept/change the slider code before
'* it is processed in RoadRunner (to overwrite existing codes).
'*****************************************************************
Public Sub SetSlider(SLD As String, Value As Long, Direction As Boolean)

End Sub

Private Sub Class_Initialize()

    Call Startup

End Sub

Private Sub Class_Terminate()
    
    Call Shutdown

End Sub
