VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ClsIniFile"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

'Windows API calls

'This writes an entry in the INI file
'It takes as parameters the section name of the INI file,
'the name of the entry, its value and the INI filename
Private Declare Function WritePrivateProfileString _
    Lib "kernel32" Alias "WritePrivateProfileStringA" _
    (ByVal lpApplicationKey As String, _
    ByVal lpKeyName As Any, _
    ByVal lsString As Any, _
    ByVal lplFilename As String) As Long

'This reads an entry in the INI file
'It takes as parameters the section name of the INI file,
'the name of the entry, its default value
'the string returned, its length and the INI filename.
Private Declare Function GetPrivateProfileString _
    Lib "kernel32" Alias "GetPrivateProfileStringA" _
    (ByVal lpApplicationKey As String, _
    ByVal lpKeyName As String, _
    ByVal lpDefault As String, _
    ByVal lpReturnedString As String, _
    ByVal nSize As Long, _
    ByVal lpFileName As String) As Long

'Variable for the filename
Private m_strFile As String

'Variable for the section name
Private m_AppKey As String

Private Sub Class_Initialize()

    m_strFile = ""
    m_AppKey = ""

End Sub

Public Property Get FileName() As String

    FileName = m_strFile

End Property

Public Property Let FileName(ByVal strFile As String)
    
    m_strFile = Trim(strFile)

End Property

Public Property Get ApplicationKey() As String
    
    ApplicationKey = m_AppKey

End Property

Public Property Let ApplicationKey(ByVal strAppKey As String)
    
    m_AppKey = Trim(strAppKey)

End Property

Private Function Asc2String(str As String) As String
'Remove all unnecessary characters from the returned string

Dim i As Integer
Dim strOP As String
Dim intAsc As Integer

    str = Trim(str)
    strOP = ""
    For i = 1 To Len(str)
        intAsc = Asc(Mid(str, i, 1))
        If intAsc > 31 Then strOP = strOP & Chr(intAsc)
    Next
    Asc2String = strOP

End Function

Public Function GetValue(ByVal keyName As String, ByVal strDefault As String) As String
'Returns the key value

Dim strVal As String * 1000
Dim ret As Long

    ret = GetPrivateProfileString(m_AppKey, keyName, strDefault, strVal, Len(strVal), m_strFile)
    If ret <> 0 Then
        GetValue = Asc2String(strVal)
    Else
        GetValue = ""
    End If

End Function

Public Function SetValue(ByVal keyName As String, ByVal strValue As String) As Boolean
'Sets the key value, returns True if succeeds

Dim ret As Long

    ret = WritePrivateProfileString(m_AppKey, keyName, strValue, m_strFile)
    If ret = 0 Then
        SetValue = False
        Exit Function
    End If
    SetValue = True

End Function

